/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import ru.turikhay.tlauncher.bootstrap.Updater;
import ru.turikhay.tlauncher.bootstrap.bridge.BootBridge;
import ru.turikhay.tlauncher.bootstrap.bridge.BootListenerAdapter;
import ru.turikhay.tlauncher.bootstrap.exception.ExceptionList;
import ru.turikhay.tlauncher.bootstrap.exception.FatalExceptionType;
import ru.turikhay.tlauncher.bootstrap.exception.InsufficientFreeSpace;
import ru.turikhay.tlauncher.bootstrap.exception.NoFileAccessException;
import ru.turikhay.tlauncher.bootstrap.exception.UnknownFreeSpaceException;
import ru.turikhay.tlauncher.bootstrap.json.Json;
import ru.turikhay.tlauncher.bootstrap.launcher.InternalLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LaunchType;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.launcher.Library;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncherTask;
import ru.turikhay.tlauncher.bootstrap.launcher.RemoteLauncher;
import ru.turikhay.tlauncher.bootstrap.meta.DownloadEntry;
import ru.turikhay.tlauncher.bootstrap.meta.LocalBootstrapMeta;
import ru.turikhay.tlauncher.bootstrap.meta.LocalLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.meta.PackageType;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteBootstrapMeta;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.meta.UpdateMeta;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskInterruptedException;
import ru.turikhay.tlauncher.bootstrap.task.TaskList;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.util.DataBuilder;
import ru.turikhay.tlauncher.bootstrap.util.FileValueConverter;
import ru.turikhay.tlauncher.bootstrap.util.JavaVersion;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.Ref;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.stream.RedirectPrintStream;
import shaded.com.getsentry.raven.DefaultRavenFactory;
import shaded.com.getsentry.raven.Raven;
import shaded.com.getsentry.raven.dsn.Dsn;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.BreadcrumbBuilder;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;
import shaded.joptsimple.ArgumentAcceptingOptionSpec;
import shaded.joptsimple.OptionParser;
import shaded.joptsimple.OptionSet;
import shaded.joptsimple.OptionSpecBuilder;
import shaded.ru.turikhay.util.windows.wmi.WMI;

public final class Bootstrap {
    private static final Raven raven = new DefaultRavenFactory().createRavenInstance(new Dsn("https://fe7b0410e04848019449cb8de9c9bc22:5c3a7bd40c9348dea0bc6858715570eb@sentry.ely.by/4?"));
    private final UserInterface ui;
    private final InternalLauncher internal;
    private final LocalBootstrapMeta meta;
    private File targetJar;
    private File targetLibFolder;
    private static RedirectPrintStream.Redirector out;
    private static RedirectPrintStream.Redirector err;

    static Bootstrap createBootstrap() {
        Bootstrap.log("Starting bootstrap...");
        Bootstrap bootstrap = new Bootstrap();
        LocalBootstrapMeta localBootstrapMeta = bootstrap.getMeta();
        Bootstrap.log("Version: " + localBootstrapMeta.getVersion());
        File defaultFile = U.requireNotNull(LocalLauncher.getDefaultFileLocation(localBootstrapMeta.getShortBrand()), "defaultFileLocation");
        File defaultLibFolder = defaultFile.getParentFile() == null ? new File("lib") : new File(defaultFile.getParentFile(), "lib");
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<LaunchType> launchTypeParser = parser.accepts("launchType", "defines launch type").withRequiredArg().ofType(LaunchType.class).defaultsTo(U.requireNotNull(localBootstrapMeta.getLaunchType(), "default LaunchType"), (LaunchType[])new LaunchType[0]);
        ArgumentAcceptingOptionSpec<File> targetFileParser = parser.accepts("targetJar", "points to the targetJar").withRequiredArg().withValuesConvertedBy(new FileValueConverter()).defaultsTo(defaultFile, (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> targetLibFolderParser = parser.accepts("targetLibFolder", "points to the library folder").withRequiredArg().withValuesConvertedBy(new FileValueConverter()).defaultsTo(defaultLibFolder, (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> brandParser = parser.accepts("brand", "defines brand name").withRequiredArg().ofType(String.class).defaultsTo(U.requireNotNull(localBootstrapMeta.getShortBrand(), "default shortBrand"), (String[])new String[0]);
        OptionSpecBuilder forceUpdateParser = parser.accepts("forceUpdate", "defines if bootstrap should update launcher on update found");
        OptionSet parsed = Bootstrap.parseJvmArgs(parser);
        localBootstrapMeta.setLaunchType((LaunchType)((Object)U.requireNotNull(launchTypeParser.value(parsed), "LaunchType")));
        Bootstrap.log(new Object[]{"Launch type:", localBootstrapMeta.getLaunchType()});
        localBootstrapMeta.setShortBrand((String)U.requireNotNull(brandParser.value(parsed), "shortBrand"));
        Bootstrap.log("Short brand: ", localBootstrapMeta.getShortBrand());
        localBootstrapMeta.setForceUpdate(parsed.has(forceUpdateParser) || localBootstrapMeta.isForceUpdate());
        Bootstrap.log("Force update?", localBootstrapMeta.isForceUpdate());
        bootstrap.setTargetJar((File)targetFileParser.value(parsed));
        Bootstrap.log("Target jar:", bootstrap.getTargetJar());
        bootstrap.setTargetLibFolder((File)targetLibFolderParser.value(parsed));
        Bootstrap.log("Target lib folder:", bootstrap.getTargetLibFolder());
        try {
            Bootstrap.checkAccessible(bootstrap.getTargetJar(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("error checking target jar: " + bootstrap.getTargetJar().getAbsolutePath(), e);
        }
        try {
            Bootstrap.checkAccessible(bootstrap.getTargetLibFolder(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("error checking target lib folder: " + bootstrap.getTargetLibFolder().getAbsolutePath(), e);
        }
        Bootstrap.recordBreadcrumb("createBootstrap", DataBuilder.create("localBootstrapMeta", localBootstrapMeta).add("targetJar", bootstrap.getTargetJar()).add("targetLibFolder", bootstrap.getTargetLibFolder()));
        return bootstrap;
    }

    private static OptionSet parseJvmArgs(OptionParser parser) {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        for (String key : parser.recognizedOptions().keySet()) {
            String value = System.getProperty("tlauncher.bootstrap." + key);
            if (value == null) continue;
            jvmArgs.add("--" + key);
            jvmArgs.add(value);
            Bootstrap.log("Found JVM arg: ", key, " ", value);
        }
        Bootstrap.recordBreadcrumb("parseJvmArgs", DataBuilder.create("list", jvmArgs));
        return parser.parse(U.toArray(jvmArgs, String.class));
    }

    public static void main(String[] args) {
        Bootstrap.checkRunningConditions();
        out = RedirectPrintStream.newRedirectorFor(System.out);
        System.setOut(out);
        err = RedirectPrintStream.newRedirectorFor(System.err);
        System.setErr(err);
        Bootstrap bootstrap = null;
        Ref<BootBridge> bootBridgeRef = new Ref<BootBridge>();
        try {
            bootstrap = Bootstrap.createBootstrap();
            bootstrap.defTask(args, bootBridgeRef).call();
        }
        catch (TaskInterruptedException interrupted) {
            Bootstrap.log("Default task was interrupted");
        }
        catch (InterruptedException interrupted) {
            Bootstrap.log("Interrupted");
        }
        catch (Exception e) {
            e.printStackTrace();
            Bootstrap.handleFatalError(bootstrap, bootBridgeRef.getObject(), e, true);
            System.exit(-1);
        }
        System.exit(0);
    }

    static void handleFatalError(Bootstrap bootstrap, BootBridge bridge, Throwable e, boolean sendSentry) {
        FatalExceptionType exceptionType = FatalExceptionType.getType(e);
        if (sendSentry) {
            EventBuilder b;
            block14: {
                LocalBootstrapMeta localBootstrapMeta = bootstrap == null ? null : bootstrap.getMeta();
                b = new EventBuilder().withEnvironment(System.getProperty("os.name")).withLevel(Event.Level.FATAL).withSentryInterface(new ExceptionInterface(e)).withRelease(localBootstrapMeta == null ? null : String.valueOf(localBootstrapMeta.getVersion()));
                if (exceptionType != null) {
                    b.withTag("type", exceptionType.name());
                }
                if (bridge != null && bridge.getClient() != null) {
                    b.withSentryInterface(new shaded.com.getsentry.raven.event.interfaces.UserInterface(bridge.getClient().toString(), null, null, null));
                }
                if (OS.WINDOWS.isCurrent()) {
                    List<String> avList;
                    try {
                        avList = WMI.getAVSoftwareList();
                    }
                    catch (Exception e0) {
                        Bootstrap.log("Could not get AV list", e0);
                        break block14;
                    }
                    int count = 0;
                    for (String av : avList) {
                        if ("Windows Defender".equals(av)) continue;
                        if (count > 1) {
                            b.withTag("av" + String.valueOf(count), av);
                        } else {
                            b.withTag("av", av);
                        }
                        ++count;
                    }
                }
            }
            raven.sendEvent(b);
        }
        if (bootstrap != null && bootstrap.getUserInterface() != null) {
            bootstrap.getUserInterface().getFrame().dispose();
        }
        if (UserInterface.getResourceBundle() != null) {
            ResourceBundle resourceBundle = UserInterface.getResourceBundle();
            String supportLink = resourceBundle.getString("support");
            if (exceptionType == null) {
                UserInterface.showError(resourceBundle.getString("error.fatal") + "\n" + supportLink, RedirectPrintStream.getBuffer().toString());
            } else {
                StringBuilder message = new StringBuilder();
                message.append(resourceBundle.getString("error." + exceptionType.nameLowerCase()));
                if (resourceBundle.containsKey("error." + exceptionType.nameLowerCase() + "." + OS.CURRENT.nameLowerCase())) {
                    message.append(' ').append(resourceBundle.getString("error." + exceptionType.nameLowerCase() + "." + OS.CURRENT.nameLowerCase()));
                }
                message.append("\n\n");
                message.append(supportLink);
                UserInterface.showError(message.toString(), U.toString(e));
            }
        }
    }

    Bootstrap(File targetJar, File targetLibFolder, boolean uiEnabled) {
        InternalLauncher internal;
        UserInterface userInterface = null;
        if (uiEnabled) {
            try {
                userInterface = new UserInterface();
            }
            catch (RuntimeException rE) {
                Bootstrap.log("User interface is not loaded:", rE);
                userInterface = null;
            }
        }
        this.ui = userInterface;
        String resourceName = "meta.json";
        try {
            this.meta = (LocalBootstrapMeta)Json.parse(U.requireNotNull(this.getClass().getResourceAsStream("meta.json"), "meta.json"), LocalBootstrapMeta.class);
        }
        catch (Exception e) {
            throw new Error("could not load meta", e);
        }
        try {
            internal = new InternalLauncher();
        }
        catch (LauncherNotFoundException e) {
            Bootstrap.log("Internal launcher is not located in the classpath");
            internal = null;
        }
        this.internal = internal;
        this.setTargetJar(targetJar);
        this.setTargetLibFolder(targetLibFolder);
        Bootstrap.recordBreadcrumb("initBootstrap", new DataBuilder().add("ui", this.ui).add("internalLauncher", String.valueOf(internal)).add("targetJar", targetJar).add("targetLibFolder", targetLibFolder));
    }

    public Bootstrap() {
        this(null, null, true);
    }

    UserInterface getUserInterface() {
        return this.ui;
    }

    public File getTargetJar() {
        return this.targetJar;
    }

    private void setTargetJar(File file) {
        this.targetJar = file;
    }

    public File getTargetLibFolder() {
        return this.targetLibFolder;
    }

    private void setTargetLibFolder(File targetLibFolder) {
        this.targetLibFolder = targetLibFolder;
    }

    public LocalBootstrapMeta getMeta() {
        return this.meta;
    }

    DownloadEntry getBootstrapUpdate(UpdateMeta updateMeta) {
        String localBootstrapChecksum;
        RemoteBootstrapMeta remoteMeta = U.requireNotNull(updateMeta, "updateMeta").getBootstrap();
        U.requireNotNull(remoteMeta, "RemoteBootstrap meta");
        U.requireNotNull(remoteMeta.getDownload(), "RemoteBootstrap download URL");
        Bootstrap.log("Local bootstrap version: " + this.meta.getVersion());
        Bootstrap.log("Remote bootstrap version: " + remoteMeta.getVersion());
        try {
            localBootstrapChecksum = U.getSHA256(U.getJar(Bootstrap.class));
        }
        catch (Exception e) {
            Bootstrap.log("Could not get local bootstrap checksum", e);
            return null;
        }
        Bootstrap.log("Current package: " + (Object)((Object)PackageType.CURRENT));
        Bootstrap.log("Remote bootstrap checksum of selected package: " + remoteMeta.getDownload(PackageType.CURRENT));
        Bootstrap.log("Local bootstrap checksum: " + localBootstrapChecksum);
        Bootstrap.log("Remote bootstrap checksum: " + remoteMeta.getDownload(PackageType.CURRENT).getChecksum());
        if (localBootstrapChecksum.equalsIgnoreCase(remoteMeta.getDownload().getChecksum())) {
            return null;
        }
        Bootstrap.recordBreadcrumb("getBootstrapUpdate", null);
        return remoteMeta.getDownload();
    }

    TaskList downloadLibraries(LocalLauncherMeta localLauncherMeta) {
        TaskList taskList = new TaskList("downloadLibraries", 4);
        File libDir = this.getTargetLibFolder();
        for (Library library : localLauncherMeta.getLibraries()) {
            taskList.submit(library.download(libDir));
        }
        Bootstrap.recordBreadcrumb("downloadLibraries", DataBuilder.create("taskList", taskList));
        return taskList;
    }

    private BootBridge createBridge(String[] args, String options) {
        BootBridge bridge = BootBridge.create(this.meta.getVersion().toString(), args, options);
        bridge.addListener(new BootListenerAdapter(){

            @Override
            public void onBootSucceeded() {
                Bootstrap.disableRedirectRecording();
            }
        });
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, args);
        Bootstrap.recordBreadcrumb("createBridge", DataBuilder.create("args", ((Object)argsList).toString()).add("options", options));
        return bridge;
    }

    Task<LocalLauncherTask> prepareLauncher(final UpdateMeta updateMeta) {
        return new Task<LocalLauncherTask>("prepareLauncher"){

            @Override
            protected LocalLauncherTask execute() throws Exception {
                RemoteLauncher remoteLauncher = updateMeta == null ? null : new RemoteLauncher(updateMeta.getLauncher());
                this.log("Remote launcher: " + remoteLauncher);
                Bootstrap.recordBreadcrumb("remoteLauncher", DataBuilder.create("value", String.valueOf(remoteLauncher)));
                LocalLauncherTask localLauncherTask = (LocalLauncherTask)this.bindTo(Bootstrap.this.getLocalLauncher(remoteLauncher), 0.0, 0.25);
                LocalLauncher localLauncher = localLauncherTask.getLauncher();
                LocalLauncherMeta localLauncherMeta = localLauncher.getMeta();
                this.log("Local launcher: " + localLauncher);
                Bootstrap.recordBreadcrumb("localLauncher", DataBuilder.create("value", String.valueOf(remoteLauncher)));
                this.log("Downloading libraries...");
                this.bindTo(Bootstrap.this.downloadLibraries(localLauncherMeta), 0.25, 1.0);
                return localLauncherTask;
            }
        };
    }

    Task<Void> startLauncher(final LocalLauncher localLauncher, final BootBridge bridge) {
        return new Task<Void>("startLauncher"){

            @Override
            protected Void execute() throws Exception {
                this.log("Starting launcher...");
                Bootstrap.recordBreadcrumb("startingLauncher", null);
                bridge.addListener(new BootListenerAdapter(){

                    @Override
                    public void onBootStateChanged(String stepName, double percentage) {
                        this.updateProgress(percentage);
                    }
                });
                return this.bindTo(Bootstrap.this.meta.getLaunchType().getStarter().start(localLauncher, bridge), 0.0, 1.0);
            }
        };
    }

    private Task<Void> defTask(final String[] args, final Ref<BootBridge> bootBridgeRef) {
        return new Task<Void>("defTask"){
            {
                super(name);
                if (Bootstrap.this.ui != null) {
                    Bootstrap.this.ui.bindToTask(this);
                }
            }

            @Override
            protected Void execute() throws Exception {
                DownloadEntry downloadEntry;
                UpdateMeta updateMeta;
                try {
                    updateMeta = this.bindTo(UpdateMeta.fetchFor(Bootstrap.this.meta.getShortBrand()), 0.0, 0.25);
                }
                catch (ExceptionList list) {
                    this.log("Could not retrieve update meta:", list);
                    Bootstrap.this.sendError(list, DataBuilder.create("type", (Object)FatalExceptionType.getType(list)));
                    updateMeta = null;
                }
                if (updateMeta != null && (downloadEntry = Bootstrap.this.getBootstrapUpdate(updateMeta)) != null) {
                    Updater updater = new Updater("bootstrapUpdate", U.getJar(Bootstrap.class), downloadEntry, true);
                    this.bindTo(updater, 0.25, 1.0);
                    return null;
                }
                LocalLauncherTask localLauncherTask = this.bindTo(Bootstrap.this.prepareLauncher(updateMeta), 0.25, 0.75);
                LocalLauncher localLauncher = localLauncherTask.getLauncher();
                BootBridge bridge = Bootstrap.this.createBridge(args, updateMeta == null ? null : updateMeta.getOptions());
                if (localLauncherTask.isUpdated() && updateMeta != null) {
                    Bootstrap.this.addUpdateMessage(bridge, updateMeta.getLauncher());
                }
                bootBridgeRef.setObject(bridge);
                this.bindTo(Bootstrap.this.startLauncher(localLauncher, bridge), 0.75, 1.0);
                this.checkInterrupted();
                this.log("Idle state: Waiting for launcher the close");
                bridge.waitUntilClose();
                return null;
            }
        };
    }

    private void addUpdateMessage(BootBridge bridge, RemoteLauncherMeta remoteLauncherMeta) {
        Map<String, String> description = remoteLauncherMeta.getDescription();
        if (description == null) {
            return;
        }
        String updateTitle = UserInterface.getLString("update.launcher.title", "Launcher was updated");
        for (Map.Entry<String, String> entry : description.entrySet()) {
            bridge.addMessage(entry.getKey(), updateTitle, entry.getValue());
        }
    }

    private Task<LocalLauncherTask> getLocalLauncher(final RemoteLauncher remote) {
        return new Task<LocalLauncherTask>("getLocalLauncher"){

            @Override
            protected LocalLauncherTask execute() throws Exception {
                File file;
                LocalLauncher local;
                this.updateProgress(0.0);
                this.log("Getting local launcher...");
                RemoteLauncherMeta remoteLauncherMeta = remote == null ? null : U.requireNotNull(remote.getMeta(), "RemoteLauncherMeta");
                try {
                    local = new LocalLauncher(Bootstrap.this.getTargetJar(), Bootstrap.this.getTargetLibFolder());
                }
                catch (LauncherNotFoundException lnfE) {
                    this.log("Could not find local launcher:", lnfE);
                    if (Bootstrap.this.internal == null) {
                        this.log("... and we have no internal one?");
                        local = null;
                    }
                    this.log("... replacing it with internal one:", Bootstrap.this.internal);
                    local = this.bindTo(Bootstrap.this.internal.toLocalLauncher(Bootstrap.this.getTargetJar(), Bootstrap.this.getTargetLibFolder()), 0.0, 0.1);
                }
                File file2 = file = local != null ? local.getFile() : Bootstrap.this.getTargetJar();
                if (local != null) {
                    LocalLauncherMeta localLauncherMeta;
                    if (remote == null) {
                        this.log("We have local launcher, but have no remote.");
                        return new LocalLauncherTask(local);
                    }
                    try {
                        localLauncherMeta = U.requireNotNull(local.getMeta(), "LocalLauncherMeta");
                    }
                    catch (IOException ioE) {
                        this.log("Could not get local launcher meta:", ioE);
                        localLauncherMeta = null;
                    }
                    this.updateProgress(0.2);
                    if (localLauncherMeta != null) {
                        U.requireNotNull(localLauncherMeta.getShortBrand(), "LocalLauncher shortBrand");
                        U.requireNotNull(localLauncherMeta.getBrand(), "LocalLauncher brand");
                        U.requireNotNull(localLauncherMeta.getMainClass(), "LocalLauncher mainClass");
                        String localLauncherHash = U.getSHA256(local.getFile());
                        this.log("Local SHA256: " + localLauncherHash);
                        this.log("Remote SHA256: " + remoteLauncherMeta.getChecksum());
                        if (!localLauncherHash.equalsIgnoreCase(remoteLauncherMeta.getChecksum())) {
                            this.log("... local SHA256 checksum is not the same as remote");
                        } else {
                            this.log("All done, local launcher is up to date.");
                            return new LocalLauncherTask(local);
                        }
                    }
                    this.updateProgress(0.5);
                }
                if (remote == null) {
                    throw new LauncherNotFoundException("could not retrieve any launcher");
                }
                local = this.bindTo(remote.toLocalLauncher(file, Bootstrap.this.getTargetLibFolder()), 0.5, 1.0);
                return new LocalLauncherTask(local, true);
            }
        };
    }

    public static void recordBreadcrumbError(Class<?> clazz, String name, Throwable t, DataBuilder b) {
        Bootstrap.recordBreadcrumb(name, "error", "class:" + clazz.getSimpleName(), b.add("exception", U.toString(t)));
    }

    public static void recordBreadcrumb(Class<?> clazz, String name, DataBuilder data) {
        Bootstrap.recordBreadcrumb(name, "info", "class:" + clazz.getSimpleName(), data);
    }

    private static void recordBreadcrumb(String name, DataBuilder data) {
        Bootstrap.recordBreadcrumb(name, "info", "general", data);
    }

    private EventBuilder prepareEvent(Event.Level level, DataBuilder b) {
        EventBuilder builder = new EventBuilder().withEnvironment(System.getProperty("os.name")).withLevel(level).withRelease(String.valueOf(this.getMeta().getVersion())).withServerName(JavaVersion.getCurrent().getVersion());
        if (b != null) {
            for (Map.Entry<String, String> entry : b.build().entrySet()) {
                builder.withExtra(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    private void sendEvent(EventBuilder builder) {
        Event event = builder.build();
        raven.sendEvent(event);
        Bootstrap.log("Event sent:", DataBuilder.create("event", event).add("environment", event.getEnvironment()).add("level", (Object)event.getLevel()).add("interfaces", event.getSentryInterfaces()).build());
    }

    private void sendError(Throwable t, DataBuilder b) {
        EventBuilder builder = this.prepareEvent(Event.Level.ERROR, b).withSentryInterface(new ExceptionInterface(t));
        this.sendEvent(builder);
    }

    private static void recordBreadcrumb(String name, String level, String category, DataBuilder data) {
        BreadcrumbBuilder b = new BreadcrumbBuilder();
        b.setLevel(level);
        b.setCategory(category);
        b.setMessage(name);
        if (data != null) {
            b.setData(data.build());
        }
        Breadcrumb breadcrumb = b.build();
        raven.getContext().recordBreadcrumb(breadcrumb);
        Bootstrap.log("Breadcrumb recorded:", DataBuilder.create("breadcrumb", breadcrumb).add("level", level).add("category", category).add("message", name).add("data", data == null ? null : data.build()).build());
    }

    private static void disableRedirectRecording() {
        if (out != null) {
            out.disableRecording();
        }
        if (err != null) {
            err.disableRecording();
        }
        Bootstrap.recordBreadcrumb("disableRedirectRecording", null);
    }

    private static void checkRunningConditions() {
        File file;
        IOException ioE;
        String message;
        block9: {
            JavaVersion supported = JavaVersion.create(1, 7, 0, 25);
            if (JavaVersion.getCurrent().compareTo(supported) == -1) {
                String message2 = "Your Java version is not supported. Please install at least " + supported.getVersion() + " from Java.com\n\u0412\u0430\u0448\u0430 \u0432\u0435\u0440\u0441\u0438\u044f Java \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c " + supported.getVersion() + " \u0441 \u0441\u0430\u0439\u0442\u0430 Java.com";
                UserInterface.showError(message2, null);
                throw new Error(message2);
            }
            message = null;
            ioE = null;
            file = null;
            File jar = U.getJar(Bootstrap.class);
            String path = jar.getAbsolutePath();
            if (path.contains("!" + File.separatorChar)) {
                message = "Please do not run (any) Java application which path contains folder name that ends with \u00ab!\u00bb\n\u041d\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0439\u0442\u0435 Java-\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f\u0445, \u0447\u0435\u0439 \u043f\u0443\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u00ab!\u00bb. \u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u0435 TLauncher \u0432 \u0434\u0440\u0443\u0433\u0443\u044e \u043f\u0430\u043f\u043a\u0443.\n\n" + path;
            } else {
                File tempFile;
                try {
                    Bootstrap.checkAccessible(jar, false);
                }
                catch (IOException jarException) {
                    file = jar;
                    message = jarException instanceof UnknownFreeSpaceException ? "Could not determine free space on partition storing Bootstrap. Please check your hard drive.\n\n\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0434\u0438\u0441\u043a \u043d\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043e\u0448\u0438\u0431\u043e\u043a." : (jarException instanceof InsufficientFreeSpace ? "Insufficient disk space on partition storing JAR file.\n\n\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043c\u0435\u0441\u0442\u0430 \u043d\u0430 \u0434\u0438\u0441\u043a\u0435. \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f JAR-\u0444\u0430\u0439\u043b. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0441\u0432\u0431\u043e\u0434\u0438\u0442\u0435 \u043c\u0435\u0441\u0442\u043e \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." : "Could not access JAR file.\n\n\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a JAR-\u0444\u0430\u0439\u043b\u0443.");
                    ioE = jarException;
                    break block9;
                }
                try {
                    tempFile = File.createTempFile("bootstrap", null);
                    Bootstrap.checkAccessible(tempFile, true);
                }
                catch (IOException tempFileException) {
                    message = tempFileException instanceof UnknownFreeSpaceException ? "Could not determine free space on partition storing temporary folder. Please check your hard drive.\n\n\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u043c \u0434\u0438\u0441\u043a\u0435. \u041b\u0438\u0431\u043e \u043e\u043d \u043f\u043e\u043b\u043e\u043d, \u043b\u0438\u0431\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0448\u0438\u0431\u043a\u0438." : (tempFileException instanceof InsufficientFreeSpace ? "Insufficient disk space on partition storing temporary folder.\n\n\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043c\u0435\u0441\u0442\u0430 \u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u043c \u0434\u0438\u0441\u043a\u0435. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u0435 \u043c\u0435\u0441\u0442\u043e \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430." : "Could not access temporary folder. Please check your hard drive.\n\n\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0434\u0438\u0441\u043a \u043d\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043e\u0448\u0438\u0431\u043e\u043a.");
                    ioE = tempFileException;
                    break block9;
                }
                if (tempFile.getParentFile() != null && tempFile.isDirectory()) {
                    ImageIO.setCacheDirectory(tempFile.getParentFile());
                }
            }
        }
        if (message != null) {
            UserInterface.showError(message, file == null ? null : file.getAbsolutePath());
            throw new Error(message, ioE);
        }
    }

    private static void checkAccessible(File file, boolean requireExistance) throws IOException {
        long freeSpace;
        if (!file.exists()) {
            if (requireExistance) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
        } else {
            NoFileAccessException.throwIfNoAccess(file);
        }
        if ((freeSpace = file.getFreeSpace()) != 0L && freeSpace < 65536L) {
            throw new InsufficientFreeSpace();
        }
    }

    private static void log(Object ... o) {
        U.log("[Bootstrap]", o);
    }
}

