/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.bootstrap.Bootstrap;
import ru.turikhay.tlauncher.bootstrap.launcher.ProcessStarter;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.stream.InputStreamCopier;
import shaded.org.apache.commons.io.IOUtils;
import shaded.org.apache.commons.lang3.StringUtils;

public final class BootstrapStarter {
    public static void main(String[] args) throws Exception {
        int exitCode = BootstrapStarter.start(args, false);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    static int start(String[] args, boolean waitForClose) throws Exception {
        File currentDir = new File(".");
        BootstrapStarter.log("Current dir: ", currentDir.getAbsolutePath());
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.addAll(BootstrapStarter.loadJvmArgs());
        jvmArgs.addAll(BootstrapStarter.loadExternalArgs(currentDir, "bootargs"));
        ArrayList<String> appArgs = new ArrayList<String>();
        Collections.addAll(appArgs, args);
        appArgs.addAll(BootstrapStarter.loadExternalArgs(currentDir, "args"));
        Process process = ProcessStarter.startJarProcess(currentDir, ProcessStarter.getSystemClasspath(), Bootstrap.class.getName(), jvmArgs, appArgs);
        BootstrapStarter.log("Inherit process started");
        if (!waitForClose) {
            return 0;
        }
        InputStreamCopier input = new InputStreamCopier(process.getInputStream(), System.out);
        InputStreamCopier error = new InputStreamCopier(process.getErrorStream(), System.err);
        input.start();
        error.start();
        int exitCode = process.waitFor();
        input.interrupt();
        error.interrupt();
        return exitCode;
    }

    private static List<String> loadJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add("-Xmx128m");
        jvmArgs.add("-Dfile.encoding=UTF-8");
        for (String propKey : System.getProperties().stringPropertyNames()) {
            if (!propKey.startsWith("tlauncher.bootstrap.")) continue;
            String value = U.requireNotNull(System.getProperty(propKey), "property \"" + propKey + "\"");
            String arg = "-D" + propKey + "=" + value;
            jvmArgs.add(arg);
            BootstrapStarter.log("Transferring property: ", arg);
        }
        return jvmArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadExternalArgs(File currentDir, String extension) {
        block6: {
            String content;
            File externalArgsFile = new File(currentDir, "tlauncher-" + OS.CURRENT.nameLowerCase() + "-" + OS.Arch.CURRENT.nameLowerCase() + "." + extension);
            if (!externalArgsFile.isFile()) {
                externalArgsFile = new File(currentDir, "tlauncher-" + OS.CURRENT.nameLowerCase() + "." + extension);
            }
            if (!externalArgsFile.isFile()) {
                externalArgsFile = new File(currentDir, "tlauncher." + extension);
            }
            if (!externalArgsFile.isFile()) break block6;
            BootstrapStarter.log("Loading arguments from file:", externalArgsFile);
            FileInputStream in = null;
            try {
                in = new FileInputStream(externalArgsFile);
                content = IOUtils.toString(in, U.UTF8);
            }
            catch (IOException ioE) {
                try {
                    BootstrapStarter.log("Cannot load arguments from file:", externalArgsFile, ioE);
                }
                catch (Throwable throwable) {
                    U.close(in);
                    throw throwable;
                }
                U.close(in);
                break block6;
            }
            U.close(in);
            return new ArrayList<String>(){
                {
                    Collections.addAll(this, StringUtils.split(content, ' '));
                }
            };
        }
        return Collections.EMPTY_LIST;
    }

    private static void log(Object ... o) {
        U.log("[BootstrapStarter]", o);
    }
}

