/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import ru.turikhay.tlauncher.bootstrap.exception.FileLockedException;
import ru.turikhay.tlauncher.bootstrap.meta.DownloadEntry;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.util.U;

public class Updater
extends Task<Void> {
    private final File destFile;
    private final DownloadEntry entry;
    private final boolean exitOnFinish;

    public Updater(String name, File destFile, DownloadEntry entry, boolean exitOnFinish) throws IOException {
        super(name);
        this.destFile = U.requireNotNull(destFile, "destFile");
        if (!destFile.isFile()) {
            throw new FileNotFoundException();
        }
        this.entry = U.requireNotNull(entry, "downloadEntry");
        this.exitOnFinish = exitOnFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws Exception {
        boolean exitOnFinish;
        block9: {
            String randomUrl = this.entry.getUrl().get(new Random().nextInt(this.entry.getUrl().size())).toString();
            UserInterface.showWarning(UserInterface.getLString("update", "Application is going to update. Please start it again manually afterwards."), randomUrl);
            exitOnFinish = this.exitOnFinish;
            File tempFile = File.createTempFile("updater", null);
            tempFile.deleteOnExit();
            try {
                this.bindTo(this.entry.toDownloadTask(this.getName(), tempFile), 0.0, 0.95);
            }
            catch (FileLockedException lockedException) {
                UserInterface.showError(UserInterface.getLString("update.locked", "File is locked by another process."), randomUrl);
                break block9;
            }
            byte[] buffer = new byte[8192];
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                int read;
                input = new FileInputStream(tempFile);
                output = new FileOutputStream(this.destFile);
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
            }
            finally {
                if (input != null) {
                    input.close();
                    tempFile.delete();
                }
                if (output != null) {
                    output.close();
                }
            }
        }
        if (exitOnFinish) {
            System.exit(0);
        }
        return null;
    }
}

