/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.bridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import ru.turikhay.tlauncher.bootstrap.bridge.BootEventDispatcher;
import ru.turikhay.tlauncher.bootstrap.bridge.BootException;
import ru.turikhay.tlauncher.bootstrap.bridge.BootListener;
import ru.turikhay.tlauncher.bootstrap.bridge.BootMessage;

public final class BootBridge {
    final ArrayList<BootListener> listenerList = new ArrayList();
    private BootEventDispatcher dispatcher;
    private final String bootstrapVersion;
    private final String[] args;
    private final String options;
    private final Map<String, BootMessage> messageMap;
    private UUID client;
    volatile boolean interrupted;

    private BootBridge(String bootstrapVersion, String[] args, String options) {
        if (args == null) {
            args = new String[]{};
        }
        this.messageMap = new HashMap<String, BootMessage>();
        this.bootstrapVersion = bootstrapVersion;
        this.args = args;
        this.options = options;
    }

    public String getBootstrapVersion() {
        return this.bootstrapVersion;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getOptions() {
        return this.options;
    }

    public UUID getClient() {
        return this.client;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    void setClient(UUID client) {
        this.client = client;
    }

    BootMessage getMessage(String locale) {
        return this.messageMap.get(locale);
    }

    public void addMessage(String locale, String title, String message) {
        this.messageMap.put(locale, new BootMessage(title, message));
    }

    public synchronized void addListener(BootListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listenerList.add(listener);
    }

    public synchronized BootEventDispatcher setupDispatcher() {
        if (this.dispatcher != null) {
            throw new IllegalStateException("dispatcher already set");
        }
        this.dispatcher = new BootEventDispatcher(this);
        return this.dispatcher;
    }

    public void waitUntilClose() throws InterruptedException, BootException {
        if (this.dispatcher == null) {
            throw new IllegalStateException("no dispatcher initialized");
        }
        this.dispatcher.waitUntilClose();
    }

    public static BootBridge create(String bootstrapVersion, String[] args, String options) {
        return new BootBridge(bootstrapVersion, args, options);
    }

    public static BootBridge create(String[] args) {
        return new BootBridge(null, args, null);
    }
}

