/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.exception;

import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.bootstrap.exception.ExceptionList;
import ru.turikhay.tlauncher.bootstrap.exception.FileLockedException;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.util.OS;

public enum FatalExceptionType {
    INTERNET_CONNECTIVITY_BLOCKED(new TypeAssertion(){

        @Override
        public boolean ensure(Throwable t) {
            return t instanceof SocketException && t.getMessage() != null && t.getMessage().startsWith("Address family not supported by protocol family") && OS.WINDOWS.isCurrent();
        }
    }),
    FILE_LOCKED(FileLockedException.class),
    CORRUPTED_INSTALLATION(ClassNotFoundException.class, NoClassDefFoundError.class),
    INTERNET_CONNECTIVITY(UnknownHostException.class, ConnectException.class, HttpRetryException.class, ProtocolException.class, SocketException.class, SocketTimeoutException.class, UnknownServiceException.class, LauncherNotFoundException.class);

    private final TypeAssertion assertion;
    private final List<Class> classList;

    private FatalExceptionType(final Class ... exceptionTypes) {
        this.assertion = null;
        this.classList = new ArrayList<Class>(){
            {
                Collections.addAll(this, exceptionTypes);
            }
        };
    }

    private FatalExceptionType(TypeAssertion assertion) {
        this.assertion = assertion;
        this.classList = null;
    }

    boolean ensure(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof ExceptionList) {
            List<Exception> list = ((ExceptionList)t).getList();
            if (list.isEmpty()) {
                return false;
            }
            boolean allNulls = true;
            for (Exception e : list) {
                FatalExceptionType type = FatalExceptionType.getType(e);
                allNulls &= type == null;
                if (type == null || type == this) continue;
                return false;
            }
            return !allNulls;
        }
        if (this.classList != null) {
            Class<?> clazz = t.getClass();
            for (Class checkClazz : this.classList) {
                if (!checkClazz.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
        return this.assertion != null && this.assertion.ensure(t);
    }

    public String nameLowerCase() {
        return this.name().toLowerCase();
    }

    public static FatalExceptionType getType(Throwable t) {
        for (FatalExceptionType type : FatalExceptionType.values()) {
            if (!type.ensure(t)) continue;
            return type;
        }
        return null;
    }

    static interface TypeAssertion {
        public boolean ensure(Throwable var1);
    }
}

