/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.exception;

import java.io.File;
import java.io.IOException;

public class NoFileAccessException
extends IOException {
    private final File file;
    private final AccessScope scope;

    public NoFileAccessException(File file, AccessScope scope) {
        super(file == null ? null : file.getAbsolutePath());
        this.file = file;
        this.scope = scope;
    }

    public static void throwIfNoAccess(File file) throws NoFileAccessException {
        if (file == null) {
            throw new NullPointerException();
        }
        for (AccessScope s : AccessScope.values()) {
            if (s.check(file)) continue;
            throw new NoFileAccessException(file, s);
        }
    }

    public static enum AccessScope {
        READ{

            @Override
            public boolean check(File file) {
                return file.canRead();
            }
        }
        ,
        WRITE{

            @Override
            public boolean check(File file) {
                return file.canWrite();
            }
        };


        public abstract boolean check(File var1);
    }
}

