/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.json;

import shaded.com.google.gson.ExclusionStrategy;
import shaded.com.google.gson.FieldAttributes;
import shaded.com.google.gson.GsonBuilder;
import shaded.com.google.gson.annotations.Expose;

final class ExposeExclusion {
    private static final Excluder serialization = new SerializationExcluder();
    private static final Excluder deserialization = new DeserializationExcluder();

    static GsonBuilder setup(GsonBuilder b) {
        b.addSerializationExclusionStrategy(serialization);
        b.addDeserializationExclusionStrategy(deserialization);
        return b;
    }

    private static class DeserializationExcluder
    extends Excluder {
        private DeserializationExcluder() {
        }

        @Override
        boolean checkAnnotation(Expose annotation) {
            return annotation.deserialize();
        }
    }

    private static class SerializationExcluder
    extends Excluder {
        private SerializationExcluder() {
        }

        @Override
        boolean checkAnnotation(Expose annotation) {
            return annotation.serialize();
        }
    }

    private static abstract class Excluder
    implements ExclusionStrategy {
        private Excluder() {
        }

        @Override
        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            Expose expose = fieldAttributes.getAnnotation(Expose.class);
            return expose != null && this.checkAnnotation(expose);
        }

        abstract boolean checkAnnotation(Expose var1);

        @Override
        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

