/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import ru.turikhay.tlauncher.bootstrap.bridge.BootBridge;
import ru.turikhay.tlauncher.bootstrap.launcher.IStarter;
import ru.turikhay.tlauncher.bootstrap.launcher.Library;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.util.U;

class ClassLoaderStarter
implements IStarter {
    ClassLoaderStarter() {
    }

    @Override
    public Task<Void> start(final LocalLauncher launcher, final BootBridge bridge) {
        U.requireNotNull(launcher, "LocalLauncher");
        return new Task<Void>("startLauncher"){

            @Override
            protected Void execute() throws Exception {
                ArrayList<URL> jarUrlList = new ArrayList<URL>();
                jarUrlList.add(launcher.getFile().toURI().toURL());
                File libFolder = launcher.getLibFolder();
                for (Library lib : launcher.getMeta().getLibraries()) {
                    File file = lib.getFile(libFolder);
                    if (!file.isFile()) {
                        throw new FileNotFoundException("classpath is not found: " + file.getAbsolutePath());
                    }
                    jarUrlList.add(file.toURI().toURL());
                }
                for (URL url : U.toArray(jarUrlList, URL.class)) {
                    this.log("Classpath entry:", url);
                }
                URLClassLoader childCl = new URLClassLoader(U.toArray(jarUrlList, URL.class), this.getClass().getClassLoader());
                Class<?> clazz = Class.forName(launcher.getMeta().getMainClass(), true, childCl);
                Method method = clazz.getMethod("launch", BootBridge.class);
                try {
                    method.invoke(null, bridge);
                }
                catch (InvocationTargetException invokeException) {
                    if (invokeException.getCause() != null && invokeException.getCause() instanceof Exception) {
                        throw (Exception)invokeException.getCause();
                    }
                    throw invokeException;
                }
                return null;
            }

            @Override
            protected void interrupted() {
                bridge.setInterrupted();
            }
        };
    }
}

