/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalCastingLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.io.IOUtils;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public class InternalLauncher
extends LocalCastingLauncher {
    private final URL url = this.getClass().getResource("/launcher.jar");
    private File tempFile;

    public InternalLauncher() throws LauncherNotFoundException {
        if (this.url == null) {
            throw new LauncherNotFoundException("internal");
        }
    }

    private InputStream getInputStream() throws IOException {
        if (this.tempFile != null) {
            return new FileInputStream(this.tempFile);
        }
        return this.url.openStream();
    }

    private void unpack(OutputStream out) throws IOException {
        IOUtils.copy(this.getInputStream(), out);
    }

    public Task<LocalLauncher> toLocalLauncher(final File file, final File libFolder) {
        return new Task<LocalLauncher>("internalToLocalLauncher"){

            @Override
            protected LocalLauncher execute() throws Exception {
                U.createFile(file);
                InternalLauncher.this.unpack(new FileOutputStream(file));
                try {
                    return new LocalLauncher(file, libFolder);
                }
                catch (LauncherNotFoundException lnfE) {
                    throw new IOException(lnfE);
                }
            }
        };
    }

    @Override
    public ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("url", this.url).append("tempFile", this.tempFile);
    }
}

