/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.turikhay.tlauncher.bootstrap.json.ToStringBuildable;
import ru.turikhay.tlauncher.bootstrap.task.DownloadTask;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.com.google.gson.annotations.Expose;
import shaded.org.apache.commons.lang3.StringUtils;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public final class Library
extends ToStringBuildable {
    private static final List<String> LIBRARY_REPO_LIST = Arrays.asList(U.shuffle("http://u.tlauncher.ru/repo/libraries/", "http://repo.tlauncher.ru/repo/libraries/", "http://turikhay.ru/tlauncher/repo/libraries/"));
    private String name;
    private String checksum;
    @Expose
    private String[] parts;

    public File getFile(File folder) {
        return new File(U.requireNotNull(folder, "folder"), this.getPath());
    }

    public DownloadTask downloadTo(File dest) {
        return new DownloadTask(this.name, this.getUrlList(), dest, this.checksum);
    }

    public DownloadTask download(File folder) {
        return this.downloadTo(this.getFile(folder));
    }

    private List<URL> getUrlList() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        String path = this.getPath();
        for (String prefix : LIBRARY_REPO_LIST) {
            urlList.add(U.toUrl(prefix + path));
        }
        return urlList;
    }

    private String getFilename() {
        return String.format("%s-%s.jar", this.getParts()[1], this.getParts()[2]);
    }

    private String getBaseDir() {
        return String.format("%s/%s/%s", StringUtils.replaceChars(this.getParts()[0], '.', '/'), this.getParts()[1], this.getParts()[2]);
    }

    public String getPath() {
        return String.format("%s/%s", this.getBaseDir(), this.getFilename());
    }

    private String[] getParts() {
        if (this.parts == null) {
            this.parts = StringUtils.split(U.requireNotNull(this.name, "name"), ":", 3);
        }
        return this.parts;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("name", this.name).append("checksum", this.checksum);
    }
}

