/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.turikhay.tlauncher.bootstrap.json.Json;
import ru.turikhay.tlauncher.bootstrap.launcher.Launcher;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.meta.LauncherMeta;
import ru.turikhay.tlauncher.bootstrap.meta.LocalLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public class LocalLauncher
extends Launcher {
    private final File file;
    private final File libFolder;
    private LocalLauncherMeta meta;

    public LocalLauncher(File file, File libFolder) throws LauncherNotFoundException {
        this.file = U.requireNotNull(file, "file");
        if (!file.exists()) {
            throw new LauncherNotFoundException("local");
        }
        this.libFolder = U.requireNotNull(libFolder, "libFolder");
    }

    public final File getFile() {
        return this.file;
    }

    public final File getLibFolder() {
        return this.libFolder;
    }

    public LocalLauncherMeta getMeta() throws IOException {
        return LocalLauncher.findMetaEntry(this.file, LocalLauncherMeta.class);
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("meta", this.meta).append("file", this.file == null ? null : this.file.getAbsolutePath()).append("libFolder", this.libFolder == null ? null : this.libFolder.getAbsolutePath());
    }

    private static File getDefaultLocation() {
        return OS.getSystemRelatedDirectory("tlauncher", true);
    }

    public static File getDefaultFileLocation(String shortBrand) {
        return new File(LocalLauncher.getDefaultLocation(), "bin/" + shortBrand.toLowerCase() + ".jar");
    }

    static <T extends LauncherMeta> T findMetaEntry(File file, Class<T> clazz) throws IOException {
        InputStream input;
        String entryName = "ru/turikhay/tlauncher/meta.json";
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (file.isFile()) {
            input = LocalLauncher.getZipEntry(file, "ru/turikhay/tlauncher/meta.json");
        } else {
            if (!(file = new File(file, "ru/turikhay/tlauncher/meta.json")).isFile()) {
                throw new FileNotFoundException("target entry is not found: " + file.getAbsolutePath());
            }
            input = new FileInputStream(file);
        }
        return (T)((LauncherMeta)Json.get().fromJson((Reader)new InputStreamReader(input, U.UTF8), clazz));
    }

    private static InputStream getZipEntry(File file, String entryName) throws IOException {
        final ZipFile zip = new ZipFile(file);
        ZipEntry metaEntry = zip.getEntry(entryName);
        if (metaEntry == null) {
            throw new IOException("could not find entry: " + entryName);
        }
        return new FilterInputStream(zip.getInputStream(metaEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zip.close();
            }
        };
    }
}

