/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.File;
import java.net.URL;
import java.util.List;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalCastingLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.task.DownloadTask;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public class RemoteLauncher
extends LocalCastingLauncher {
    private final RemoteLauncherMeta meta;

    public RemoteLauncher(RemoteLauncherMeta meta) {
        this.meta = U.requireNotNull(meta, "RemoteLauncherMeta");
    }

    public Task<LocalLauncher> toLocalLauncher(final File file, final File libFolder) {
        return new Task<LocalLauncher>("remoteToLocalLauncher"){

            @Override
            protected LocalLauncher execute() throws Exception {
                this.log("Replacing local launcher with remote one");
                List<URL> urlList = U.requireNotNull(RemoteLauncher.this.meta.getDownloads(), "remoteLauncher download list");
                this.bindTo(new DownloadTask("remoteLauncherDownload", urlList, file, RemoteLauncher.this.meta.getChecksum()), 0.0, 1.0);
                return new LocalLauncher(file, libFolder);
            }
        };
    }

    public RemoteLauncherMeta getMeta() {
        return this.meta;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("meta", this.meta);
    }
}

