/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.meta;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import ru.turikhay.tlauncher.bootstrap.Bootstrap;
import ru.turikhay.tlauncher.bootstrap.exception.ExceptionList;
import ru.turikhay.tlauncher.bootstrap.json.Json;
import ru.turikhay.tlauncher.bootstrap.json.UpdateDeserializer;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteBootstrapMeta;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.util.DataBuilder;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.com.google.gson.Gson;
import shaded.com.google.gson.annotations.Expose;
import shaded.org.apache.commons.io.IOUtils;

public class UpdateMeta {
    private static final List<String> UPDATE_URL_LIST = new ArrayList<String>(){
        {
            this.add("http://cdn.turikhay.ru/tlauncher/%s/bootstrap.json");
            Collections.addAll(this, U.shuffle("https://tlauncherrepo.com/%s/bootstrap.json", "https://u.tlauncher.ru/%s/bootstrap.json", "https://turikhay.ru/tlauncher/%s/bootstrap.json"));
        }
    };
    private static final TimeZone UTC;
    protected long pendingUpdateUTC;
    protected UpdateEntry update;
    protected Map<String, String> description;
    @Expose
    protected String options;

    public static Task<UpdateMeta> fetchFor(final String brand) throws ExceptionList {
        U.requireNotNull(brand, "brand");
        return new Task<UpdateMeta>("fetchUpdate"){

            @Override
            protected UpdateMeta execute() throws Exception {
                this.log("Requesting update for: " + brand);
                Gson gson = UpdateMeta.createGson();
                ArrayList<Exception> eList = new ArrayList<Exception>();
                for (int attempt = 1; attempt <= 5; ++attempt) {
                    for (int i = 0; i < UPDATE_URL_LIST.size(); ++i) {
                        this.checkInterrupted();
                        this.updateProgress((i + 1) / UPDATE_URL_LIST.size());
                        String _url = null;
                        long time = System.currentTimeMillis();
                        try {
                            _url = String.format((String)UPDATE_URL_LIST.get(i), brand);
                            URL url = new URL(_url);
                            this.log("URL: ", url);
                            UpdateMeta meta = UpdateMeta.fetchFrom(gson, UpdateMeta.setupConnection(url, attempt));
                            if (!meta.isOutdated()) {
                                this.updateProgress(1.0);
                                this.log("Success!");
                                Bootstrap.recordBreadcrumb(UpdateMeta.class, "fetch_success", DataBuilder.create("url", url).add("delta_ms", System.currentTimeMillis() - time).add("attempt", attempt));
                                return meta;
                            }
                            this.log("... is outdated, skipping");
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            eList.add(e);
                            Bootstrap.recordBreadcrumbError(UpdateMeta.class, "fetch_failed", e, DataBuilder.create("url", _url).add("delta_ms", System.currentTimeMillis() - time).add("attempt", attempt));
                        }
                    }
                }
                throw new ExceptionList(eList);
            }
        };
    }

    private static Gson createGson() {
        return Json.build().registerTypeAdapter((Type)((Object)UpdateMeta.class), new UpdateDeserializer()).create();
    }

    private static UpdateMeta fetchFrom(Gson gson, InputStream in) throws Exception {
        String read = null;
        try {
            read = IOUtils.toString(U.toReader(in));
            return gson.fromJson(read, UpdateMeta.class);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                if (read == null) {
                    throw (IOException)e.getCause();
                }
                cause = e.getCause();
            }
            if (read == null) {
                throw e;
            }
            if (read.length() > 1000) {
                read = read.substring(0, 997) + "...";
            }
            throw new IOException("could not read: \"" + read + "\"", cause);
        }
    }

    private static InputStream setupConnection(URL url, int attempt) throws IOException {
        int timeout = attempt * 1500;
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        return connection.getInputStream();
    }

    private static Calendar calendar() {
        return Calendar.getInstance(UTC);
    }

    private static Calendar calendar(long millis) {
        Calendar c = UpdateMeta.calendar();
        c.setTimeInMillis(millis);
        return c;
    }

    public boolean isOutdated() {
        return this.pendingUpdateUTC > 0L && UpdateMeta.calendar().after(UpdateMeta.calendar(this.pendingUpdateUTC * 1000L));
    }

    public RemoteBootstrapMeta getBootstrap() {
        return this.update == null ? null : this.update.bootstrap;
    }

    public RemoteLauncherMeta getLauncher() {
        return this.update == null ? null : this.update.launcher;
    }

    public Map<String, String> getDescription() {
        return this.description == null ? null : Collections.unmodifiableMap(this.description);
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    static {
        UPDATE_URL_LIST.add("https://tlaun.ch/%s/bootstrap.json");
        UTC = TimeZone.getTimeZone("UTC");
    }

    private static class UpdateEntry {
        private RemoteBootstrapMeta bootstrap;
        private RemoteLauncherMeta launcher;
    }
}

