/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import ru.turikhay.tlauncher.bootstrap.Bootstrap;
import ru.turikhay.tlauncher.bootstrap.exception.ExceptionList;
import ru.turikhay.tlauncher.bootstrap.exception.FileLockedException;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskInterruptedException;
import ru.turikhay.tlauncher.bootstrap.util.DataBuilder;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.io.FileUtils;

public class DownloadTask
extends Task<Void> {
    private final List<URL> urlList;
    private final File file;
    private final String sha256;

    public DownloadTask(String name, List<URL> urlList, File file, String sha256) {
        super(name);
        if (U.requireNotNull(urlList, "urlList").isEmpty()) {
            throw new IllegalArgumentException("url list is empty");
        }
        this.urlList = new ArrayList<URL>(urlList);
        this.file = file;
        this.sha256 = sha256;
    }

    @Override
    protected Void execute() throws Exception {
        this.updateProgress(-1.0);
        if (this.file.isFile() && this.sha256 != null) {
            this.log("File exists, checking checksum: ", this.sha256);
            String hash = U.getSHA256(this.file);
            if (this.sha256.equalsIgnoreCase(hash)) {
                this.log("File is the same. Download skipped.");
                return null;
            }
            this.log("File might be corrupted: ", hash);
            Bootstrap.recordBreadcrumb(DownloadTask.class, "file_corrupted", DataBuilder.create("file", this.file.getAbsolutePath()).add("expected_hash", this.sha256).add("got_hash", hash));
        }
        ArrayList<Exception> ioEList = new ArrayList<Exception>();
        for (URL url : this.urlList) {
            try {
                this.downloadUrl(url);
            }
            catch (TaskInterruptedException interrupted) {
                throw interrupted;
            }
            catch (FileLockedException locked) {
                this.log("File is locked:", locked);
                throw locked;
            }
            catch (IOException ioE) {
                this.log("Failed to download:", url, ioE);
                ioEList.add(ioE);
                Bootstrap.recordBreadcrumbError(DownloadTask.class, "error", ioE, DataBuilder.create("url", url).add("sha256", this.sha256));
                continue;
            }
            return null;
        }
        throw new ExceptionList(ioEList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadUrl(URL url) throws IOException, TaskInterruptedException {
        this.log("Downloading:", url);
        URLConnection connection = url.openConnection(U.getProxy());
        InputStream in = null;
        FileOutputStream out = null;
        double contentLength = 0.0;
        try {
            int i;
            File temp = File.createTempFile("tlauncher", null);
            temp.deleteOnExit();
            in = connection.getInputStream();
            out = new FileOutputStream(temp);
            byte[] buffer = new byte[2048];
            long read = 0L;
            contentLength = connection.getContentLengthLong();
            while ((i = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, i);
                read += (long)i;
                if (contentLength != 0.0) {
                    this.updateProgress((double)read / contentLength);
                }
                this.checkInterrupted();
            }
            this.log("Downloaded", read, " bytes out of", connection.getContentLengthLong());
            if (this.sha256 != null) {
                this.log("Checking SHA256... Expected: ", this.sha256);
                ((OutputStream)out).close();
                String gotSha256 = U.getSHA256(temp);
                this.log("Got: ", gotSha256);
                if (!this.sha256.equalsIgnoreCase(gotSha256)) {
                    this.log("Invalid checksum");
                    throw new IOException("invalid checksum. expected: " + this.sha256 + "; got: " + gotSha256);
                }
            }
            this.log("Downloaded successfully, copying back...");
            ((OutputStream)out).close();
            boolean tryCopy = false;
            do {
                try {
                    FileUtils.copyFile(temp, this.file);
                }
                catch (FileNotFoundException fnf) {
                    FileLockedException locked = FileLockedException.getIfPresent(fnf);
                    if (tryCopy) {
                        throw locked == null ? fnf : locked;
                    }
                    if (locked != null) {
                        this.log("We got the situation! File is locked. Let's wait some time...", locked);
                    } else {
                        this.log("File is probably locked, waiting:", fnf, temp, this.file);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interrupted) {
                        throw new TaskInterruptedException(this);
                    }
                    tryCopy = true;
                }
            } while (tryCopy);
            Bootstrap.recordBreadcrumb(DownloadTask.class, "success", DataBuilder.create("url", url).add("sha256", this.sha256));
        }
        catch (Throwable throwable) {
            U.close(in, out);
            throw throwable;
        }
        U.close(in, out);
    }
}

