/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.turikhay.tlauncher.bootstrap.task.TaskInterruptedException;
import ru.turikhay.tlauncher.bootstrap.task.TaskListener;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import shaded.org.apache.commons.lang3.builder.ToStringStyle;

public abstract class Task<T>
implements Callable<T> {
    Task bindingTask;
    Task boundTask;
    private double boundTaskProgressStart;
    private double boundTaskProgressDelta;
    private final AtomicBoolean executing = new AtomicBoolean();
    private volatile boolean interrupted;
    private List<TaskListener> listenerList = new ArrayList<TaskListener>();
    private TaskListener[] listenersArray;
    private final String name;
    private final String logPrefix;
    private double progress;

    public Task(String name) {
        this.name = name;
        this.logPrefix = "[" + this.getClass().getSimpleName() + ":" + name + ']';
    }

    public final String getName() {
        return this.name;
    }

    public final void addListener(TaskListener listener) {
        U.requireNotNull(listener, "listener");
        if (this.listenersArray != null) {
            throw new IllegalStateException();
        }
        this.listenerList.add(listener);
    }

    public final Task getBindingTask() {
        return this.bindingTask;
    }

    public final void interrupt() {
        this.log("interrupted");
        this.interrupted = true;
        this.interrupted();
        if (this.bindingTask != null) {
            this.bindingTask.interrupt();
        }
    }

    protected void interrupted() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final T call() throws Exception {
        T t;
        block21: {
            Exception e;
            block20: {
                if (this.executing.getAndSet(true)) {
                    throw new IllegalArgumentException("already executing");
                }
                this.listenersArray = new TaskListener[this.listenerList.size()];
                this.listenerList.toArray(this.listenersArray);
                if (this.listenersArray != null) {
                    for (TaskListener listener : this.listenersArray) {
                        listener.onTaskStarted(this);
                    }
                }
                e = null;
                try {
                    t = this.execute();
                    if (!this.interrupted) break block20;
                }
                catch (InterruptedException inEx) {
                    try {
                        this.interrupted = true;
                        throw inEx;
                        catch (Exception ex) {
                            e = ex;
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.interrupted) {
                            this.log("interruption confirmed");
                            this.updateProgress(-1.0);
                            for (TaskListener listener : this.listenersArray) {
                                listener.onTaskInterrupted(this);
                            }
                        } else if (e == null) {
                            this.updateProgress(1.0);
                            this.log("Done!");
                            for (TaskListener listener : this.listenersArray) {
                                listener.onTaskSucceeded(this);
                            }
                        } else {
                            this.log("Failed:", e);
                            for (TaskListener listener : this.listenersArray) {
                                listener.onTaskErrored(this, e);
                            }
                        }
                        this.listenerList.clear();
                        this.listenersArray = null;
                        this.executing.set(false);
                        this.unbind();
                        throw throwable;
                    }
                }
                this.log("interruption confirmed");
                this.updateProgress(-1.0);
                for (TaskListener listener : this.listenersArray) {
                    listener.onTaskInterrupted(this);
                }
                break block21;
            }
            if (e == null) {
                this.updateProgress(1.0);
                this.log("Done!");
                for (TaskListener listener : this.listenersArray) {
                    listener.onTaskSucceeded(this);
                }
            } else {
                this.log("Failed:", e);
                for (TaskListener listener : this.listenersArray) {
                    listener.onTaskErrored(this, e);
                }
            }
        }
        this.listenerList.clear();
        this.listenersArray = null;
        this.executing.set(false);
        this.unbind();
        return t;
    }

    private void unbind() throws Exception {
        this.bindTo(null, 0.0, 0.0);
    }

    protected final <V> V bindTo(Task<V> task, double startProgress, double stopProgress) throws Exception {
        if (startProgress > stopProgress) {
            throw new IllegalArgumentException();
        }
        if (this.listenersArray != null) {
            for (TaskListener listener : this.listenersArray) {
                listener.onTaskBound(this, task);
            }
        }
        if (task != null) {
            this.bindingTask = task;
            if (task.boundTask != null) {
                throw new IllegalStateException("task is already bound");
            }
            task.boundTask = this;
            task.boundTaskProgressStart = startProgress;
            task.boundTaskProgressDelta = stopProgress - startProgress;
            V result = task.call();
            this.updateProgress(stopProgress);
            this.unbind();
            this.checkInterrupted();
            return result;
        }
        if (this.bindingTask != null) {
            if (this.bindingTask.boundTask == this) {
                this.bindingTask.boundTask = null;
            }
            this.bindingTask = null;
        }
        return null;
    }

    public final double getProgress() {
        return this.progress;
    }

    protected final void updateProgress(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            percentage = -1.0;
        }
        this.progress = percentage;
        if (this.listenersArray != null) {
            for (TaskListener listener : this.listenersArray) {
                listener.onTaskUpdated(this, percentage);
            }
        }
        if (this.boundTask != null) {
            this.boundTask.updateProgress(percentage == -1.0 ? this.boundTaskProgressStart : this.boundTaskProgressStart + percentage * this.boundTaskProgressDelta);
        }
    }

    public final boolean isExecuting() {
        return this.executing.get();
    }

    protected final void checkInterrupted() throws TaskInterruptedException {
        if (this.interrupted) {
            throw new TaskInterruptedException(this);
        }
    }

    protected final boolean isInterrupted() {
        return this.interrupted;
    }

    protected ToStringBuilder toStringBuilder() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", this.name);
    }

    public final String toString() {
        return this.toStringBuilder().build();
    }

    protected abstract T execute() throws Exception;

    protected void log(Object ... o) {
        U.log(this.logPrefix, o);
    }
}

