/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.task;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import ru.turikhay.tlauncher.bootstrap.task.ExceptionHandler;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public final class TaskList
extends Task<Void> {
    private final ExecutorService service;
    private final boolean shutdownAfter;
    private final Map<Task, Future> taskMap = new Hashtable<Task, Future>();
    private static ThreadFactory threadFactory;

    public TaskList(String name, ExecutorService service, boolean shutdownAfter) {
        super(name);
        this.service = U.requireNotNull(service, "service");
        this.shutdownAfter = shutdownAfter;
    }

    public TaskList(String name, int maxThreads) {
        this(name, Executors.newFixedThreadPool(maxThreads, TaskList.getThreadFactory()), true);
    }

    public <T> Future<T> submit(Task<T> task) {
        if (this == task) {
            throw new IllegalArgumentException("cannot add task list to itself");
        }
        Future<T> future = this.service.submit(task);
        this.taskMap.put(task, future);
        return future;
    }

    @Override
    protected Void execute() throws Exception {
        Exception error = null;
        if (!this.taskMap.isEmpty()) {
            boolean allDone;
            do {
                allDone = true;
                if (error != null || this.isInterrupted()) {
                    this.cancellAll();
                    break;
                }
                double progress = 0.0;
                for (Map.Entry<Task, Future> entry : this.taskMap.entrySet()) {
                    double currentProgress;
                    if (allDone &= entry.getValue().isDone()) {
                        try {
                            entry.getValue().get();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (Exception e) {
                            error = e;
                        }
                    }
                    if (!((currentProgress = entry.getKey().getProgress()) > 0.0)) continue;
                    progress += currentProgress;
                }
                this.updateProgress(progress / (double)this.taskMap.size());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interrupted) {
                    this.cancellAll();
                }
            } while (!allDone);
        }
        if (this.shutdownAfter) {
            this.service.shutdown();
        }
        if (error != null) {
            throw error;
        }
        this.checkInterrupted();
        return null;
    }

    private void cancellAll() {
        for (Task task : this.taskMap.keySet()) {
            task.interrupt();
        }
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("map", this.taskMap);
    }

    private static ThreadFactory getThreadFactory() {
        if (threadFactory == null) {
            threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setUncaughtExceptionHandler(ExceptionHandler.get());
                    return t;
                }
            };
        }
        return threadFactory;
    }
}

