/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskListener;
import ru.turikhay.tlauncher.bootstrap.task.TaskListenerAdapter;
import ru.turikhay.tlauncher.bootstrap.ui.Alert;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.UTF8Control;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import shaded.org.apache.commons.lang3.builder.ToStringStyle;

public final class UserInterface {
    private static final ResourceBundle resourceBundle;
    private final JFrame frame;
    private final JLabel iconLabel;
    private final JProgressBar progressBar;
    private final TaskListener taskListener;
    private Task bindingTask;

    public UserInterface() throws HeadlessException {
        if (!UserInterface.isHeaded()) {
            throw new HeadlessException();
        }
        this.frame = new JFrame();
        try {
            this.frame.setType(Window.Type.UTILITY);
        }
        catch (Error error) {
            // empty catch block
        }
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.frame.getContentPane().add(panel);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        layout.setVgap(2);
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.iconLabel = new JLabel();
        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("icon.png")));
        this.iconLabel.setOpaque(false);
        panel.add((Component)this.iconLabel, "West");
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(300, 0));
        this.progressBar.setOpaque(false);
        panel.add((Component)this.progressBar, "Center");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (UserInterface.this.bindingTask != null && UserInterface.this.bindingTask.isExecuting()) {
                    UserInterface.this.bindingTask.interrupt();
                }
            }
        });
        this.taskListener = new TaskListenerAdapter(){

            @Override
            public void onTaskStarted(Task task) {
                UserInterface.log(new Object[]{"Task started"});
                if (UserInterface.this.frame.isDisplayable()) {
                    UserInterface.this.frame.setLocationRelativeTo(null);
                    UserInterface.this.frame.setVisible(true);
                    UserInterface.this.progressBar.setValue(0);
                    UserInterface.this.progressBar.setIndeterminate(true);
                }
            }

            @Override
            public void onTaskUpdated(Task task, double percentage) {
                if (UserInterface.this.frame.isDisplayable()) {
                    int newValue;
                    int n = newValue = percentage < 0.0 ? -1 : (int)(percentage * 100.0);
                    if (UserInterface.this.progressBar.getValue() - newValue != 0) {
                        UserInterface.log(new Object[]{"Task updated:", percentage});
                        Task childTask = UserInterface.this.getChildTask(task, 2);
                        if (childTask.getProgress() < 0.0) {
                            UserInterface.this.progressBar.setIndeterminate(true);
                        } else {
                            UserInterface.this.progressBar.setIndeterminate(false);
                            UserInterface.this.progressBar.setValue(newValue);
                        }
                        StringBuilder title = new StringBuilder();
                        title.append(UserInterface.getLString("appname", "Bootstrap")).append(" :: ");
                        title.append(newValue == -1 ? "..." : newValue + "%").append(" :: ");
                        try {
                            title.append(resourceBundle.getString("loading.task." + childTask.getName()));
                        }
                        catch (MissingResourceException missing) {
                            title.append(childTask.getName());
                        }
                        UserInterface.this.frame.setTitle(title.toString());
                    }
                    if (percentage == 1.0) {
                        this.onTaskSucceeded(task);
                    }
                }
            }

            @Override
            public void onTaskInterrupted(Task task) {
                UserInterface.log(new Object[]{"Task interrupted"});
                if (UserInterface.this.frame.isDisplayable()) {
                    UserInterface.this.frame.dispose();
                }
            }

            @Override
            public void onTaskSucceeded(Task task) {
                UserInterface.log(new Object[]{"Task succeed"});
                if (UserInterface.this.frame.isDisplayable()) {
                    UserInterface.this.progressBar.setValue(100);
                    UserInterface.this.frame.dispose();
                }
            }
        };
        this.frame.setTitle(UserInterface.getLString("appname", "Bootstrap"));
        this.frame.pack();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void bindToTask(Task task) {
        if (this.bindingTask != null && this.bindingTask.isExecuting()) {
            throw new IllegalStateException();
        }
        this.bindingTask = task;
        if (this.bindingTask != null) {
            this.bindingTask.addListener(this.taskListener);
        }
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("task", this.bindingTask).build();
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static String getLString(String key, String defaultValue) {
        return resourceBundle == null ? defaultValue : (resourceBundle.containsKey(key) ? resourceBundle.getString(key) : defaultValue);
    }

    public static void showError(String message, Object textarea) {
        if (UserInterface.isHeaded()) {
            Alert.showError(message, textarea);
        }
    }

    public static void showWarning(String message, Object textarea) {
        if (UserInterface.isHeaded()) {
            Alert.showWarning(message, textarea);
        }
    }

    public static boolean isHeaded() {
        return !GraphicsEnvironment.isHeadless();
    }

    private Task getChildTask(Task task, int depth) {
        Task child = task.getBindingTask();
        if (child == null || depth == 0) {
            return task;
        }
        return this.getChildTask(child, depth - 1);
    }

    private static void log(Object ... o) {
        U.log("[UI]", o);
    }

    static {
        ResourceBundle b = null;
        if (UserInterface.isHeaded()) {
            try {
                b = ResourceBundle.getBundle("bootstrap", new UTF8Control());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        resourceBundle = b;
    }
}

