/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.StringUtils;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import shaded.org.apache.commons.lang3.builder.ToStringStyle;

public final class JavaVersion
implements Comparable<JavaVersion> {
    private static JavaVersion CURRENT;
    private final String version;
    private final String identifier;
    private final int epoch;
    private final int major;
    private final int minor;
    private final int update;
    private final boolean beta;
    private final boolean ea;
    private final double d;
    private static final Pattern pattern;

    public static JavaVersion getCurrent() {
        if (CURRENT == null) {
            JavaVersion version;
            String sVersion = System.getProperty("java.version");
            try {
                version = JavaVersion.parse(sVersion);
            }
            catch (RuntimeException rE) {
                U.log("Could not parse java version:", sVersion, rE);
                version = JavaVersion.parse("1.6.0");
            }
            CURRENT = version;
        }
        return CURRENT;
    }

    private JavaVersion(String version, String identifier, int epoch, int major, int minor, int update) {
        if (StringUtils.isBlank(version)) {
            throw new IllegalArgumentException("version");
        }
        this.version = version;
        this.identifier = StringUtils.isBlank(identifier) ? null : identifier;
        this.epoch = epoch == 0 ? 1 : JavaVersion.ifPositive(epoch, "epoch");
        this.major = JavaVersion.ifPositive(major, "major");
        this.minor = JavaVersion.ifNotNegative(minor, "minor");
        if (identifier != null && update == 0) {
            update = -1;
        }
        this.update = JavaVersion.ifNotSmallerMinusOne(update, "update");
        this.beta = Pattern.compile(".+-b[0-9]+.*").matcher(version).matches();
        this.ea = version.contains("-ea");
        this.d = Double.parseDouble(epoch + "." + major);
    }

    public String getVersion() {
        return this.version;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getUpdate() {
        return this.update;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public boolean isEarlyAccess() {
        return this.ea;
    }

    public boolean isRelease() {
        return this.identifier == null;
    }

    @Override
    public int compareTo(JavaVersion o) {
        U.requireNotNull(o, "version");
        int epochCompare = JavaVersion.compare(this.getEpoch(), o.getEpoch());
        if (epochCompare != 0) {
            return epochCompare;
        }
        int majorCompare = JavaVersion.compare(this.getMajor(), o.getMajor());
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = JavaVersion.compare(this.getMinor(), o.getMinor());
        if (minorCompare != 0) {
            return minorCompare;
        }
        int updateCompare = JavaVersion.compare(this.getUpdate(), o.getUpdate());
        if (updateCompare != 0) {
            return updateCompare;
        }
        int currentRelease = JavaVersion.boolToInt(this.isRelease());
        int compareRelease = JavaVersion.boolToInt(o.isRelease());
        return currentRelease - compareRelease;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("version", this.getVersion()).append("identifier", this.getIdentifier()).append("epoch", this.getEpoch()).append("major", this.getMajor()).append("minor", this.getMinor()).append("update", this.getUpdate()).append("beta", this.isBeta()).append("ea", this.isEarlyAccess()).append("release", this.isRelease()).build();
    }

    public static JavaVersion create(int epoch, int major, int minor, int update) {
        return new JavaVersion(epoch + "." + major + "." + minor + (update > 0 ? "_" + update : ""), null, epoch, major, minor, update);
    }

    public static JavaVersion parse(String version) {
        if (StringUtils.isBlank(version)) {
            throw new IllegalArgumentException("version");
        }
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("could not parse java version");
        }
        if (matcher.groupCount() != 5) {
            throw new IllegalArgumentException("illegal group count: " + matcher.groupCount());
        }
        return new JavaVersion(version, matcher.group(5), JavaVersion.parse(matcher.group(1), "epoch", true), JavaVersion.parse(matcher.group(2), "major"), JavaVersion.parse(matcher.group(3), "minor", true), JavaVersion.parse(matcher.group(4), "update", true));
    }

    private static int parse(String str, String name, boolean zeroifNull) {
        RuntimeException nested = null;
        if (StringUtils.isEmpty(str)) {
            if (zeroifNull) {
                return 0;
            }
        } else {
            try {
                return Integer.parseInt(str);
            }
            catch (RuntimeException rE) {
                nested = rE;
            }
        }
        throw new IllegalArgumentException("could not parse " + name, nested);
    }

    private static int parse(String str, String name) {
        return JavaVersion.parse(str, name, false);
    }

    private static int ifPositive(int num, String name) {
        if (num <= 0) {
            throw new IllegalArgumentException(name + " must be positive");
        }
        return num;
    }

    private static int ifNotNegative(int num, String name) {
        if (num < 0) {
            throw new IllegalArgumentException(name + " must not be negative");
        }
        return num;
    }

    private static int ifNotSmallerMinusOne(int num, String name) {
        if (num < -1) {
            throw new IllegalArgumentException(name + " must not be less than -1");
        }
        return num;
    }

    private static int compare(int i0, int i1) {
        return i0 < i1 ? -1 : (i0 == i1 ? 0 : 1);
    }

    private static int boolToInt(boolean b) {
        return b ? 1 : 0;
    }

    static {
        pattern = Pattern.compile("(?:([0-9]+)\\.)?([0-9]+)(?:\\.([0-9]+))?(?:_([0-9]+))?(?:-(.+))?");
    }
}

