/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URL;
import ru.turikhay.tlauncher.bootstrap.util.U;

public enum OS {
    LINUX("linux", "unix"),
    WINDOWS("win"),
    OSX("mac"),
    SOLARIS("solaris", "sunos"),
    UNKNOWN("unknown");

    public static final OS CURRENT;
    private final String[] aliases;
    private final String lowerCase;

    public static boolean isAny(OS ... any) {
        for (OS os : any) {
            if (CURRENT != os) continue;
            return true;
        }
        return false;
    }

    public static File getSystemRelatedFile(String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (CURRENT) {
            case LINUX: 
            case SOLARIS: {
                file = new File(userHome, path);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case OSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static File getSystemRelatedDirectory(String path, boolean hide) {
        if (hide && !OS.isAny(OSX, UNKNOWN)) {
            path = '.' + path;
        }
        return OS.getSystemRelatedFile(path);
    }

    public static boolean openUri(URI uri) {
        OS.log("Opening URL: " + uri.toASCIIString());
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean openUrl(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return OS.openUri(uri);
    }

    private OS(String ... aliases) {
        this.aliases = aliases;
        this.lowerCase = this.name().toLowerCase();
    }

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public String nameLowerCase() {
        return this.lowerCase;
    }

    private static void log(Object ... o) {
        U.log("[OS]", o);
    }

    static {
        String name = System.getProperty("os.name").toLowerCase();
        OS current = UNKNOWN;
        block0: for (OS os : OS.values()) {
            for (String alias : os.aliases) {
                if (!name.contains(alias)) continue;
                current = os;
                continue block0;
            }
        }
        CURRENT = current;
    }

    public static enum Arch {
        x86("32"),
        x64("64"),
        UNKNOWN(null);

        public static final Arch CURRENT;
        private final String determiner;
        private final String lowerCase;

        private Arch(String determiner) {
            this.determiner = determiner;
            this.lowerCase = this.name().toLowerCase();
        }

        public String nameLowerCase() {
            return this.lowerCase;
        }

        static {
            String dataModel = System.getProperty("sun.arch.data.model");
            Arch current = UNKNOWN;
            if (dataModel != null) {
                for (Arch arch : Arch.values()) {
                    if (!dataModel.equals(arch.determiner)) continue;
                    current = arch;
                    break;
                }
            }
            CURRENT = current;
        }
    }
}

