/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import ru.turikhay.tlauncher.bootstrap.util.Factory;
import ru.turikhay.tlauncher.bootstrap.util.WeakObjectPool;

public final class U {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Random rnd = new Random();
    private static final WeakObjectPool<MessageDigest> SHA256Pool = new WeakObjectPool<MessageDigest>(new Factory<MessageDigest>(){

        @Override
        public MessageDigest createNew() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException nsaE) {
                throw new Error(nsaE);
            }
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String prefix, Object ... o) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.print(prefix);
            System.out.print(' ');
            if (o == null) {
                System.out.println("null");
            } else {
                for (Object anO : o) {
                    if (anO instanceof String) {
                        System.out.print(anO);
                        continue;
                    }
                    if (anO instanceof Throwable) {
                        System.out.println();
                        System.out.println(U.toString((Throwable)anO));
                        continue;
                    }
                    System.out.print(" ");
                    System.out.print(anO);
                }
                System.out.println();
            }
        }
    }

    public static <T> T requireNotNull(T obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name);
        }
        return obj;
    }

    public static Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public static void close(Closeable ... cl) {
        for (Closeable c : cl) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA256(File file) throws IOException {
        WeakObjectPool.ObjectRef digestRef = SHA256Pool.get();
        try {
            int nread;
            MessageDigest digest = (MessageDigest)digestRef.get();
            FileInputStream fis = new FileInputStream(file);
            byte[] dataBytes = new byte[1024];
            while ((nread = fis.read(dataBytes)) != -1) {
                digest.update(dataBytes, 0, nread);
            }
            String string = String.format("%064x", new BigInteger(1, digest.digest()));
            return string;
        }
        finally {
            digestRef.free();
        }
    }

    public static File getJar(Class clazz) {
        try {
            return new File(URLDecoder.decode(clazz.getProtectionDomain().getCodeSource().getLocation().getPath(), UTF8.name()));
        }
        catch (UnsupportedEncodingException ueE) {
            throw new Error(ueE);
        }
    }

    public static String toString(Throwable t) {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(out));
        return new String(out.toByteArray());
    }

    public static Locale getLocale(String locale) {
        if (locale == null) {
            return null;
        }
        for (Locale l : Locale.getAvailableLocales()) {
            if (!l.toString().equals(locale)) continue;
            return l;
        }
        return null;
    }

    private static <T> void swap(T[] arr, int i, int j) {
        T tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static <T> T[] shuffle(T ... arr) {
        for (int i = arr.length; i > 1; --i) {
            U.swap(arr, i - 1, rnd.nextInt(i));
        }
        return arr;
    }

    public static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static void createDir(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("could not create dir: " + dir.getAbsolutePath());
        }
    }

    public static void createFile(File file) throws IOException {
        IOException cause;
        block7: {
            if (file.isFile()) {
                return;
            }
            cause = null;
            if (file.getParentFile() != null) {
                try {
                    U.createDir(file.getParentFile());
                }
                catch (IOException ioE) {
                    cause = ioE;
                    break block7;
                }
            }
            try {
                file.createNewFile();
            }
            catch (IOException ioE) {
                cause = ioE;
                break block7;
            }
            if (file.isFile()) {
                return;
            }
        }
        throw new IOException("could not create file: " + file.getAbsolutePath(), cause);
    }

    public static <T> T[] toArray(List<T> list, Class<T> classOfT) {
        Object[] arr = (Object[])Array.newInstance(classOfT, list.size());
        list.toArray(arr);
        return arr;
    }

    public static InputStreamReader toReader(InputStream in) {
        return new InputStreamReader(in, UTF8);
    }
}

