/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.turikhay.tlauncher.bootstrap.util.Factory;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.WeakObjectPool;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import shaded.org.apache.commons.lang3.builder.ToStringStyle;

public final class WeakObjectPool<T> {
    private final Factory<T> factory;
    private final List<WeakObjectPool.ObjectRef<T>> objects = new ArrayList<WeakObjectPool.ObjectRef<T>>();

    public WeakObjectPool(Factory<T> factory) {
        this.factory = U.requireNotNull(factory, "factory");
    }

    public synchronized WeakObjectPool.ObjectRef<T> get() {
        Iterator<WeakObjectPool.ObjectRef<T>> i = this.objects.iterator();
        while (i.hasNext()) {
            ObjectRef ref = (ObjectRef)i.next();
            if (ref.trySetUsable()) {
                return ref;
            }
            if (ref.ref.get() != null) continue;
            i.remove();
        }
        ObjectRef newRef = new ObjectRef(U.requireNotNull(this.factory.createNew(), "newObj"));
        this.objects.add((WeakObjectPool.ObjectRef<T>)newRef);
        return newRef;
    }

    public final class ObjectRef<T> {
        private final WeakReference<T> ref;
        private T strongRef;
        private final AtomicBoolean inUse = new AtomicBoolean(true);

        private ObjectRef(T obj) {
            this.ref = new WeakReference<T>(U.requireNotNull(obj, "object"));
        }

        public T get() {
            if (this.inUse.get()) {
                return this.ref.get();
            }
            throw new IllegalStateException("object " + this.ref + " is not intended to be used");
        }

        public void free() {
            if (!this.inUse.compareAndSet(true, false)) {
                throw new IllegalStateException("object " + this.ref + " was not in use");
            }
            this.strongRef = null;
        }

        private boolean trySetUsable() {
            if (this.inUse.compareAndSet(false, true)) {
                this.strongRef = this.ref.get();
                return this.strongRef != null;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (super.equals(o)) {
                return true;
            }
            if (!(o instanceof ObjectRef)) {
                return false;
            }
            T obj = this.get();
            T compare = ((ObjectRef)o).get();
            if (obj == null) {
                return compare == null;
            }
            return obj.equals(compare);
        }

        public String toString() {
            Object obj = this.ref.get();
            boolean use = this.inUse.get();
            return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("obj", obj).append("inUse", use).build();
        }
    }
}

