/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shaded.org.apache.commons.io.IOUtils;

public class BufferedOutputStringStream
extends OutputStream {
    private final ReadWriteByteBuffer bBuffer = new ReadWriteByteBuffer();
    protected String bufferedLine;
    protected int caret;

    @Override
    public synchronized void write(int b) {
        this.bBuffer.write(b);
        if (b == 10) {
            try {
                this.bufferedLine = new String(IOUtils.toByteArray(this.bBuffer));
            }
            catch (IOException ioE) {
                throw new Error(ioE);
            }
            this.flush();
        }
    }

    @Override
    public synchronized void flush() {
        this.caret = 0;
        this.bufferedLine = "";
    }

    private class ReadWriteByteBuffer
    extends InputStream {
        private byte[] buffer = new byte[1024];
        private int readIndex = 0;
        private int writeIndex = 0;

        private ReadWriteByteBuffer() {
        }

        public void write(int b) {
            if (this.writeIndex == this.buffer.length) {
                byte[] newBuffer = new byte[this.buffer.length + 1024];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
            this.buffer[this.writeIndex++] = (byte)b;
        }

        @Override
        public int read() {
            if (this.writeIndex == -1 || this.readIndex == this.writeIndex) {
                return -1;
            }
            return this.buffer[this.readIndex++];
        }

        @Override
        public void reset() {
            this.readIndex = 0;
            this.writeIndex = 0;
        }
    }
}

