/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util.stream;

import java.io.PrintStream;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.stream.BufferedOutputStringStream;

public final class RedirectPrintStream {
    private static final StringBuffer globalBuffer = new StringBuffer();

    public static StringBuffer getBuffer() {
        return globalBuffer;
    }

    public static Redirector newRedirectorFor(PrintStream redirectTo) {
        U.requireNotNull(redirectTo, "given print stream");
        return new Redirector(new RedirectorOutputStream(redirectTo));
    }

    private static class RedirectorOutputStream
    extends BufferedOutputStringStream {
        private final PrintStream redirectTo;
        private Redirector parent;
        private boolean recordingEnabled = true;

        RedirectorOutputStream(PrintStream redirectTo) {
            this.redirectTo = redirectTo;
        }

        @Override
        public synchronized void flush() {
            if (this.recordingEnabled) {
                globalBuffer.append(this.bufferedLine);
                if (this.parent != null) {
                    this.recordingEnabled = this.parent.recordingEnabled;
                }
            }
            this.redirectTo.print(this.bufferedLine);
            this.redirectTo.flush();
            super.flush();
        }
    }

    public static class Redirector
    extends PrintStream {
        private boolean recordingEnabled = true;

        private Redirector(RedirectorOutputStream out) {
            super(out);
            out.parent = this;
        }

        public void disableRecording() {
            this.recordingEnabled = false;
        }
    }
}

