/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.core.io;

import java.io.Serializable;
import shaded.com.fasterxml.jackson.core.SerializableString;
import shaded.com.fasterxml.jackson.core.io.JsonStringEncoder;

public class SerializedString
implements Serializable,
SerializableString {
    protected final String _value;
    protected byte[] _unquotedUTF8Ref;

    public SerializedString(String v) {
        if (v == null) {
            throw new IllegalStateException("Null String illegal for SerializedString");
        }
        this._value = v;
    }

    @Override
    public final String getValue() {
        return this._value;
    }

    @Override
    public final byte[] asUnquotedUTF8() {
        byte[] result = this._unquotedUTF8Ref;
        if (result == null) {
            this._unquotedUTF8Ref = result = JsonStringEncoder.getInstance().encodeAsUTF8(this._value);
        }
        return result;
    }

    public final String toString() {
        return this._value;
    }

    public final int hashCode() {
        return this._value.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SerializedString other = (SerializedString)o;
        return this._value.equals(other._value);
    }
}

