/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.core.sym;

import java.util.concurrent.atomic.AtomicReference;

public final class ByteQuadsCanonicalizer {
    protected final ByteQuadsCanonicalizer _parent = null;
    protected final AtomicReference<TableInfo> _tableInfo;
    private final int _seed;
    protected boolean _intern;
    protected final boolean _failOnDoS;
    protected int[] _hashArea;
    protected int _hashSize;
    protected int _secondaryStart;
    protected int _tertiaryStart;
    protected int _count;
    protected int _spilloverEnd;

    private ByteQuadsCanonicalizer(int sz, boolean intern, int seed, boolean failOnDoS) {
        this._seed = seed;
        this._intern = intern;
        this._failOnDoS = failOnDoS;
        if (sz < 16) {
            sz = 16;
        } else if ((sz & sz - 1) != 0) {
            int curr;
            for (curr = 16; curr < sz; curr += curr) {
            }
            sz = curr;
        }
        this._tableInfo = new AtomicReference<TableInfo>(TableInfo.createInitial(sz));
    }

    public static ByteQuadsCanonicalizer createRoot() {
        long now = System.currentTimeMillis();
        int seed = (int)now + (int)(now >>> 32) | 1;
        return ByteQuadsCanonicalizer.createRoot(seed);
    }

    protected static ByteQuadsCanonicalizer createRoot(int seed) {
        return new ByteQuadsCanonicalizer(64, true, seed, true);
    }

    public int primaryCount() {
        int count = 0;
        int end = this._secondaryStart;
        for (int offset = 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public int secondaryCount() {
        int count = 0;
        int end = this._tertiaryStart;
        for (int offset = this._secondaryStart + 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public int tertiaryCount() {
        int offset;
        int count = 0;
        int end = offset + this._hashSize;
        for (offset = this._tertiaryStart + 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public int spilloverCount() {
        return this._spilloverEnd - this._spilloverStart() >> 2;
    }

    public int totalCount() {
        int count = 0;
        int end = this._hashSize << 3;
        for (int offset = 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        int pri = this.primaryCount();
        int sec = this.secondaryCount();
        int tert = this.tertiaryCount();
        int spill = this.spilloverCount();
        int total = this.totalCount();
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", this.getClass().getName(), this._count, this._hashSize, pri, sec, tert, spill, total, pri + sec + tert + spill, total);
    }

    private final int _spilloverStart() {
        int offset = this._hashSize;
        return (offset << 3) - offset;
    }

    static int _calcTertiaryShift(int primarySlots) {
        int tertSlots = primarySlots >> 2;
        if (tertSlots < 64) {
            return 4;
        }
        if (tertSlots <= 256) {
            return 5;
        }
        if (tertSlots <= 1024) {
            return 6;
        }
        return 7;
    }

    private static final class TableInfo {
        public final int size;
        public final int count;
        public final int tertiaryShift;
        public final int[] mainHash;
        public final String[] names;
        public final int spilloverEnd;
        public final int longNameOffset;

        public TableInfo(int size, int count, int tertiaryShift, int[] mainHash, String[] names, int spilloverEnd, int longNameOffset) {
            this.size = size;
            this.count = count;
            this.tertiaryShift = tertiaryShift;
            this.mainHash = mainHash;
            this.names = names;
            this.spilloverEnd = spilloverEnd;
            this.longNameOffset = longNameOffset;
        }

        public static TableInfo createInitial(int sz) {
            int hashAreaSize = sz << 3;
            int tertShift = ByteQuadsCanonicalizer._calcTertiaryShift(sz);
            return new TableInfo(sz, 0, tertShift, new int[hashAreaSize], new String[sz << 1], hashAreaSize - sz, hashAreaSize);
        }
    }
}

