/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import shaded.com.getsentry.raven.Raven;
import shaded.com.getsentry.raven.RavenFactory;
import shaded.com.getsentry.raven.buffer.Buffer;
import shaded.com.getsentry.raven.buffer.DiskBuffer;
import shaded.com.getsentry.raven.connection.AsyncConnection;
import shaded.com.getsentry.raven.connection.BufferedConnection;
import shaded.com.getsentry.raven.connection.Connection;
import shaded.com.getsentry.raven.connection.HttpConnection;
import shaded.com.getsentry.raven.connection.NoopConnection;
import shaded.com.getsentry.raven.connection.OutputStreamConnection;
import shaded.com.getsentry.raven.dsn.Dsn;
import shaded.com.getsentry.raven.event.helper.ContextBuilderHelper;
import shaded.com.getsentry.raven.event.helper.HttpEventBuilderHelper;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;
import shaded.com.getsentry.raven.event.interfaces.HttpInterface;
import shaded.com.getsentry.raven.event.interfaces.MessageInterface;
import shaded.com.getsentry.raven.event.interfaces.StackTraceInterface;
import shaded.com.getsentry.raven.event.interfaces.UserInterface;
import shaded.com.getsentry.raven.marshaller.Marshaller;
import shaded.com.getsentry.raven.marshaller.json.ExceptionInterfaceBinding;
import shaded.com.getsentry.raven.marshaller.json.HttpInterfaceBinding;
import shaded.com.getsentry.raven.marshaller.json.JsonMarshaller;
import shaded.com.getsentry.raven.marshaller.json.MessageInterfaceBinding;
import shaded.com.getsentry.raven.marshaller.json.StackTraceInterfaceBinding;
import shaded.com.getsentry.raven.marshaller.json.UserInterfaceBinding;
import shaded.com.getsentry.raven.util.Util;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class DefaultRavenFactory
extends RavenFactory {
    public static final int TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(1L);
    public static final long BUFFER_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final long ASYNC_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    private static final Logger logger = LoggerFactory.getLogger(DefaultRavenFactory.class);
    private static final String FALSE = Boolean.FALSE.toString();
    private static final Map<String, RejectedExecutionHandler> REJECT_EXECUTION_HANDLERS = new HashMap<String, RejectedExecutionHandler>();

    public Raven createRavenInstance(Dsn dsn) {
        Raven raven = new Raven(this.createConnection(dsn));
        try {
            Class.forName("javax.servlet.ServletRequestListener", false, this.getClass().getClassLoader());
            raven.addBuilderHelper(new HttpEventBuilderHelper());
        }
        catch (ClassNotFoundException e) {
            logger.debug("The current environment doesn't provide access to servlets,or provides an unsupported version.");
        }
        raven.addBuilderHelper(new ContextBuilderHelper(raven));
        return raven;
    }

    protected Connection createConnection(Dsn dsn) {
        Connection connection;
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
            logger.info("Using an HTTP connection to Sentry.");
            connection = this.createHttpConnection(dsn);
        } else if (protocol.equalsIgnoreCase("out")) {
            logger.info("Using StdOut to send events.");
            connection = this.createStdOutConnection(dsn);
        } else if (protocol.equalsIgnoreCase("noop")) {
            logger.info("Using noop to send events.");
            connection = new NoopConnection();
        } else {
            throw new IllegalStateException("Couldn't create a connection for the protocol '" + protocol + "'");
        }
        Buffer eventBuffer = this.getBuffer(dsn);
        if (eventBuffer != null) {
            long flushtime = this.getBufferFlushtime(dsn);
            boolean gracefulShutdown = this.getBufferedConnectionGracefulShutdownEnabled(dsn);
            Long shutdownTimeout = this.getBufferedConnectionShutdownTimeout(dsn);
            connection = new BufferedConnection(connection, eventBuffer, flushtime, gracefulShutdown, shutdownTimeout);
        }
        if (this.getAsyncEnabled(dsn)) {
            connection = this.createAsyncConnection(dsn, connection);
        }
        return connection;
    }

    protected Connection createAsyncConnection(Dsn dsn, Connection connection) {
        int maxThreads = this.getAsyncThreads(dsn);
        int priority = this.getAsyncPriority(dsn);
        int queueSize = this.getAsyncQueueSize(dsn);
        LinkedBlockingDeque<Runnable> queue = queueSize == -1 ? new LinkedBlockingDeque<Runnable>() : new LinkedBlockingDeque(queueSize);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory(priority), this.getRejectedExecutionHandler(dsn));
        boolean gracefulShutdown = this.getAsyncGracefulShutdownEnabled(dsn);
        long shutdownTimeout = this.getAsyncShutdownTimeout(dsn);
        return new AsyncConnection(connection, executorService, gracefulShutdown, shutdownTimeout);
    }

    protected Connection createHttpConnection(Dsn dsn) {
        URL sentryApiUrl = HttpConnection.getSentryApiUrl(dsn.getUri(), dsn.getProjectId());
        String proxyHost = this.getProxyHost(dsn);
        int proxyPort = this.getProxyPort(dsn);
        Proxy proxy = null;
        if (proxyHost != null) {
            InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
        }
        HttpConnection httpConnection = new HttpConnection(sentryApiUrl, dsn.getPublicKey(), dsn.getSecretKey(), proxy);
        Marshaller marshaller = this.createMarshaller(dsn);
        httpConnection.setMarshaller(marshaller);
        int timeout = this.getTimeout(dsn);
        httpConnection.setTimeout(timeout);
        boolean bypassSecurityEnabled = this.getBypassSecurityEnabled(dsn);
        httpConnection.setBypassSecurity(bypassSecurityEnabled);
        return httpConnection;
    }

    protected Connection createStdOutConnection(Dsn dsn) {
        OutputStreamConnection stdOutConnection = new OutputStreamConnection(System.out);
        stdOutConnection.setMarshaller(this.createMarshaller(dsn));
        return stdOutConnection;
    }

    protected Marshaller createMarshaller(Dsn dsn) {
        int maxMessageLength = this.getMaxMessageLength(dsn);
        JsonMarshaller marshaller = new JsonMarshaller(maxMessageLength);
        StackTraceInterfaceBinding stackTraceBinding = new StackTraceInterfaceBinding();
        stackTraceBinding.setRemoveCommonFramesWithEnclosing(this.getHideCommonFramesEnabled(dsn));
        stackTraceBinding.setNotInAppFrames(this.getNotInAppFrames());
        marshaller.addInterfaceBinding(StackTraceInterface.class, stackTraceBinding);
        marshaller.addInterfaceBinding(ExceptionInterface.class, new ExceptionInterfaceBinding(stackTraceBinding));
        marshaller.addInterfaceBinding(MessageInterface.class, new MessageInterfaceBinding(maxMessageLength));
        marshaller.addInterfaceBinding(UserInterface.class, new UserInterfaceBinding());
        HttpInterfaceBinding httpBinding = new HttpInterfaceBinding();
        marshaller.addInterfaceBinding(HttpInterface.class, httpBinding);
        marshaller.setCompression(this.getCompressionEnabled(dsn));
        return marshaller;
    }

    protected Collection<String> getNotInAppFrames() {
        return Arrays.asList("shaded.com.sun.", "java.", "javax.", "shaded.org.omg.", "sun.", "junit.", "shaded.com.intellij.rt.");
    }

    protected boolean getAsyncEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get("raven.async"));
    }

    protected RejectedExecutionHandler getRejectedExecutionHandler(Dsn dsn) {
        RejectedExecutionHandler handler;
        String overflowName = "discardold";
        if (dsn.getOptions().containsKey("raven.async.queue.overflow")) {
            overflowName = dsn.getOptions().get("raven.async.queue.overflow").toLowerCase();
        }
        if ((handler = REJECT_EXECUTION_HANDLERS.get(overflowName)) == null) {
            String options = Arrays.toString(REJECT_EXECUTION_HANDLERS.keySet().toArray());
            throw new RuntimeException("RejectedExecutionHandler not found: '" + overflowName + "', valid choices are: " + options);
        }
        return handler;
    }

    protected long getBufferedConnectionShutdownTimeout(Dsn dsn) {
        return Util.parseLong(dsn.getOptions().get("raven.buffer.shutdowntimeout"), BUFFER_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getBufferedConnectionGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get("raven.buffer.gracefulshutdown"));
    }

    protected long getBufferFlushtime(Dsn dsn) {
        return Util.parseLong(dsn.getOptions().get("raven.buffer.flushtime"), 60000L);
    }

    protected long getAsyncShutdownTimeout(Dsn dsn) {
        return Util.parseLong(dsn.getOptions().get("raven.async.shutdowntimeout"), ASYNC_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getAsyncGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get("raven.async.gracefulshutdown"));
    }

    protected int getAsyncQueueSize(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.async.queuesize"), 50);
    }

    protected int getAsyncPriority(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.async.priority"), 1);
    }

    protected int getAsyncThreads(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.async.threads"), Runtime.getRuntime().availableProcessors());
    }

    protected boolean getBypassSecurityEnabled(Dsn dsn) {
        return dsn.getProtocolSettings().contains("naive");
    }

    protected int getProxyPort(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.http.proxy.port"), 80);
    }

    protected String getProxyHost(Dsn dsn) {
        return dsn.getOptions().get("raven.http.proxy.host");
    }

    protected boolean getCompressionEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get("raven.compression"));
    }

    protected boolean getHideCommonFramesEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get("raven.stacktrace.hidecommon"));
    }

    protected int getMaxMessageLength(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.maxmessagelength"), 1000);
    }

    protected int getTimeout(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.timeout"), TIMEOUT_DEFAULT);
    }

    protected Buffer getBuffer(Dsn dsn) {
        String bufferDir = dsn.getOptions().get("raven.buffer.dir");
        if (bufferDir != null) {
            return new DiskBuffer(new File(bufferDir), this.getBufferSize(dsn));
        }
        return null;
    }

    protected int getBufferSize(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get("raven.buffer.size"), 50);
    }

    static {
        REJECT_EXECUTION_HANDLERS.put("sync", new ThreadPoolExecutor.CallerRunsPolicy());
        REJECT_EXECUTION_HANDLERS.put("discardnew", new ThreadPoolExecutor.DiscardPolicy());
        REJECT_EXECUTION_HANDLERS.put("discardold", new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    protected static final class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        private DaemonThreadFactory(int priority) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "raven-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }
}

