/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import shaded.com.getsentry.raven.RavenContext;
import shaded.com.getsentry.raven.connection.Connection;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.helper.EventBuilderHelper;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class Raven {
    private static final Logger logger = LoggerFactory.getLogger(Raven.class);
    private static volatile Raven stored = null;
    private volatile Connection connection;
    private final Set<EventBuilderHelper> builderHelpers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ThreadLocal<RavenContext> context = new ThreadLocal<RavenContext>(){

        @Override
        protected RavenContext initialValue() {
            RavenContext ctx = new RavenContext();
            ctx.activate();
            return ctx;
        }
    };

    @Deprecated
    public Raven() {
        stored = this;
    }

    public Raven(Connection connection) {
        this.connection = connection;
        stored = this;
    }

    public void runBuilderHelpers(EventBuilder eventBuilder) {
        for (EventBuilderHelper builderHelper : this.builderHelpers) {
            builderHelper.helpBuildingEvent(eventBuilder);
        }
    }

    public void sendEvent(Event event) {
        try {
            this.connection.send(event);
        }
        catch (Exception e) {
            logger.error("An exception occurred while sending the event to Sentry.", e);
        }
        finally {
            this.context.get().setLastEventId(event.getId());
        }
    }

    public void sendEvent(EventBuilder eventBuilder) {
        this.runBuilderHelpers(eventBuilder);
        Event event = eventBuilder.build();
        this.sendEvent(event);
    }

    public void addBuilderHelper(EventBuilderHelper builderHelper) {
        logger.debug("Adding '{}' to the list of builder helpers.", builderHelper);
        this.builderHelpers.add(builderHelper);
    }

    public RavenContext getContext() {
        return this.context.get();
    }

    public String toString() {
        return "Raven{name=" + RavenEnvironment.NAME + ", connection=" + this.connection + '}';
    }
}

