/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.UUID;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.util.CircularFifoQueue;

public class RavenContext
implements AutoCloseable {
    private static ThreadLocal<IdentityHashMap<RavenContext, RavenContext>> activeContexts = new ThreadLocal<IdentityHashMap<RavenContext, RavenContext>>(){

        @Override
        protected IdentityHashMap<RavenContext, RavenContext> initialValue() {
            return new IdentityHashMap<RavenContext, RavenContext>();
        }
    };
    private UUID lastEventId;
    private CircularFifoQueue<Breadcrumb> breadcrumbs;

    public RavenContext() {
        this(100);
    }

    public RavenContext(int breadcrumbLimit) {
        this.breadcrumbs = new CircularFifoQueue(breadcrumbLimit);
    }

    public void activate() {
        activeContexts.get().put(this, this);
    }

    public void deactivate() {
        activeContexts.get().remove(this);
    }

    @Override
    public void close() {
        this.deactivate();
    }

    public Iterator<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs.iterator();
    }

    public void recordBreadcrumb(Breadcrumb breadcrumb) {
        this.breadcrumbs.add(breadcrumb);
    }

    public void setLastEventId(UUID id) {
        this.lastEventId = id;
    }
}

