/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.config;

import shaded.com.getsentry.raven.config.JndiLookup;
import shaded.com.getsentry.raven.dsn.Dsn;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public final class Lookup {
    private static final Logger logger = LoggerFactory.getLogger(JndiLookup.class);

    public static String lookup(String key) {
        String value = null;
        try {
            Class.forName("javax.naming.InitialContext", false, Dsn.class.getClassLoader());
            value = JndiLookup.jndiLookup(key);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            logger.debug("JNDI not available", e);
        }
        if (value == null) {
            value = System.getProperty("sentry." + key.toLowerCase());
        }
        if (value == null) {
            value = System.getenv("SENTRY_" + key.toUpperCase());
        }
        if (value != null) {
            return value.trim();
        }
        return null;
    }
}

