/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.connection;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import shaded.com.getsentry.raven.buffer.Buffer;
import shaded.com.getsentry.raven.connection.Connection;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Event;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class BufferedConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(BufferedConnection.class);
    private final ShutDownHook shutDownHook = new ShutDownHook();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });
    private Connection actualConnection;
    private Buffer buffer;
    private boolean gracefulShutdown;
    private long shutdownTimeout;
    private volatile boolean closed = false;

    public BufferedConnection(Connection actualConnection, Buffer buffer, long flushtime, boolean gracefulShutdown, long shutdownTimeout) {
        this.actualConnection = actualConnection;
        this.buffer = buffer;
        this.gracefulShutdown = gracefulShutdown;
        this.shutdownTimeout = shutdownTimeout;
        if (gracefulShutdown) {
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
        Flusher flusher = new Flusher();
        this.executorService.scheduleWithFixedDelay(flusher, flushtime, flushtime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void send(Event event) {
        try {
            this.actualConnection.send(event);
            this.buffer.discard(event);
        }
        catch (Exception e) {
            this.buffer.add(event);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.gracefulShutdown) {
            this.shutDownHook.enabled = false;
        }
        this.closed = true;
        this.executorService.shutdown();
        try {
            if (this.shutdownTimeout == -1L) {
                long waitBetweenLoggingMs = 5000L;
                while (!this.executorService.awaitTermination(waitBetweenLoggingMs, TimeUnit.MILLISECONDS)) {
                    logger.info("Still waiting on buffer flusher executor to terminate.");
                }
            } else if (!this.executorService.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown took too much time, forcing the shutdown.");
                List<Runnable> tasks = this.executorService.shutdownNow();
                logger.info("{} tasks failed to execute before the shutdown.", tasks.size());
            }
            logger.info("Shutdown finished.");
        }
        catch (InterruptedException e) {
            logger.error("Graceful shutdown interrupted, forcing the shutdown.");
            List<Runnable> tasks = this.executorService.shutdownNow();
            logger.info("{} tasks failed to execute before the shutdown.", tasks.size());
        }
        finally {
            this.actualConnection.close();
        }
    }

    private final class ShutDownHook
    extends Thread {
        private volatile boolean enabled = true;

        private ShutDownHook() {
        }

        @Override
        public void run() {
            if (!this.enabled) {
                return;
            }
            RavenEnvironment.startManagingThread();
            try {
                logger.info("Automatic shutdown of the buffered connection");
                BufferedConnection.this.close();
            }
            catch (Exception e) {
                logger.error("An exception occurred while closing the connection.", e);
            }
            finally {
                RavenEnvironment.stopManagingThread();
            }
        }
    }

    private class Flusher
    implements Runnable {
        private Flusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.trace("Running Flusher");
            RavenEnvironment.startManagingThread();
            try {
                Iterator<Event> events = BufferedConnection.this.buffer.getEvents();
                while (events.hasNext() && !BufferedConnection.this.closed) {
                    Event event = events.next();
                    try {
                        logger.trace("Flusher attempting to send Event: " + event.getId());
                        BufferedConnection.this.send(event);
                        logger.trace("Flusher successfully sent Event: " + event.getId());
                    }
                    catch (Exception e) {
                        logger.debug("Flusher failed to send Event: " + event.getId(), e);
                        logger.trace("Flusher run exiting early.");
                        RavenEnvironment.stopManagingThread();
                        return;
                    }
                }
                logger.trace("Flusher run exiting, no more events to send.");
            }
            finally {
                RavenEnvironment.stopManagingThread();
            }
        }
    }
}

