/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import shaded.com.getsentry.raven.connection.AbstractConnection;
import shaded.com.getsentry.raven.connection.ConnectionException;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.marshaller.Marshaller;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger logger = LoggerFactory.getLogger(HttpConnection.class);
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final HostnameVerifier NAIVE_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    };
    private final URL sentryUrl;
    private final Proxy proxy;
    private Marshaller marshaller;
    private int timeout = DEFAULT_TIMEOUT;
    private boolean bypassSecurity = false;

    public HttpConnection(URL sentryUrl, String publicKey, String secretKey, Proxy proxy) {
        super(publicKey, secretKey);
        this.sentryUrl = sentryUrl;
        this.proxy = proxy;
    }

    public static URL getSentryApiUrl(URI sentryUri, String projectId) {
        try {
            String url = sentryUri.toString() + "api/" + projectId + "/store/";
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't build a valid URL from the Sentry API.", e);
        }
    }

    protected HttpURLConnection getConnection() {
        try {
            HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)this.sentryUrl.openConnection(this.proxy) : (HttpURLConnection)this.sentryUrl.openConnection();
            if (this.bypassSecurity && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(NAIVE_VERIFIER);
            }
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.timeout);
            connection.setRequestProperty("User-Agent", RavenEnvironment.NAME);
            connection.setRequestProperty("X-Sentry-Auth", this.getAuthHeader());
            return connection;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't set up a connection to the sentry server.", e);
        }
    }

    @Override
    protected void doSend(Event event) throws ConnectionException {
        HttpURLConnection connection = this.getConnection();
        try {
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            this.marshaller.marshall(event, outputStream);
            outputStream.close();
            connection.getInputStream().close();
        }
        catch (IOException e) {
            String errorMessage = null;
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                errorMessage = this.getErrorMessageFromStream(errorStream);
            }
            if (null == errorMessage || errorMessage.isEmpty()) {
                errorMessage = "An exception occurred while submitting the event to the sentry server.";
            }
            throw new ConnectionException(errorMessage, e);
        }
        finally {
            connection.disconnect();
        }
    }

    private String getErrorMessageFromStream(InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
        }
        catch (Exception e2) {
            logger.error("Exception while reading the error message from the connection.", e2);
        }
        return sb.toString();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setBypassSecurity(boolean bypassSecurity) {
        this.bypassSecurity = bypassSecurity;
    }

    @Override
    public void close() throws IOException {
    }
}

