/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.environment;

import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public final class RavenEnvironment {
    public static final String NAME = ResourceBundle.getBundle("raven-build").getString("build.name");
    protected static final ThreadLocal<AtomicInteger> RAVEN_THREAD = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(RavenEnvironment.class);

    private RavenEnvironment() {
    }

    public static void startManagingThread() {
        try {
            if (RavenEnvironment.isManagingThread()) {
                logger.warn("Thread already managed by Raven");
            }
        }
        finally {
            RAVEN_THREAD.get().incrementAndGet();
        }
    }

    public static void stopManagingThread() {
        try {
            if (!RavenEnvironment.isManagingThread()) {
                RavenEnvironment.startManagingThread();
                logger.warn("Thread not yet managed by Raven");
            }
        }
        finally {
            RAVEN_THREAD.get().decrementAndGet();
        }
    }

    public static boolean isManagingThread() {
        return RAVEN_THREAD.get().get() > 0;
    }
}

