/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.interfaces.SentryInterface;

public class Event
implements Serializable {
    private final UUID id;
    private String message;
    private Date timestamp;
    private Level level;
    private String logger;
    private String platform;
    private String culprit;
    private Map<String, String> tags = new HashMap<String, String>();
    private List<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
    private String release;
    private String environment;
    private String serverName;
    private transient Map<String, Object> extra = new HashMap<String, Object>();
    private List<String> fingerprint;
    private String checksum;
    private Map<String, SentryInterface> sentryInterfaces = new HashMap<String, SentryInterface>();

    Event(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("The id can't be null");
        }
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTimestamp() {
        return this.timestamp != null ? (Date)this.timestamp.clone() : null;
    }

    void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Level getLevel() {
        return this.level;
    }

    void setLevel(Level level) {
        this.level = level;
    }

    public String getLogger() {
        return this.logger;
    }

    public String getPlatform() {
        return this.platform;
    }

    void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getCulprit() {
        return this.culprit;
    }

    public List<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    void setBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getServerName() {
        return this.serverName;
    }

    void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRelease() {
        return this.release;
    }

    void setRelease(String release) {
        this.release = release;
    }

    public String getEnvironment() {
        return this.environment;
    }

    void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public List<String> getFingerprint() {
        return this.fingerprint;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Map<String, SentryInterface> getSentryInterfaces() {
        return this.sentryInterfaces;
    }

    void setSentryInterfaces(Map<String, SentryInterface> sentryInterfaces) {
        this.sentryInterfaces = sentryInterfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Event)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Event{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + ", logger='" + this.logger + '\'' + '}';
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

