/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.event;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.interfaces.SentryInterface;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class EventBuilder {
    public static final long HOSTNAME_CACHE_DURATION = TimeUnit.HOURS.toMillis(5L);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final HostnameCache HOSTNAME_CACHE = new HostnameCache(HOSTNAME_CACHE_DURATION);
    private final Event event;
    private boolean alreadyBuilt = false;

    public EventBuilder() {
        this(UUID.randomUUID());
    }

    public EventBuilder(UUID eventId) {
        this.event = new Event(eventId);
    }

    private static void autoSetMissingValues(Event event) {
        if (event.getTimestamp() == null) {
            event.setTimestamp(new Date());
        }
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
        if (event.getServerName() == null) {
            event.setServerName(HOSTNAME_CACHE.getHostname());
        }
    }

    private static void makeImmutable(Event event) {
        event.setTags(Collections.unmodifiableMap(event.getTags()));
        event.setBreadcrumbs(Collections.unmodifiableList(event.getBreadcrumbs()));
        event.setExtra(Collections.unmodifiableMap(event.getExtra()));
        event.setSentryInterfaces(Collections.unmodifiableMap(event.getSentryInterfaces()));
    }

    public EventBuilder withLevel(Event.Level level) {
        this.event.setLevel(level);
        return this;
    }

    public EventBuilder withRelease(String release) {
        this.event.setRelease(release);
        return this;
    }

    public EventBuilder withEnvironment(String environment) {
        this.event.setEnvironment(environment);
        return this;
    }

    public EventBuilder withTag(String tagKey, String tagValue) {
        this.event.getTags().put(tagKey, tagValue);
        return this;
    }

    public EventBuilder withBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.event.setBreadcrumbs(breadcrumbs);
        return this;
    }

    public EventBuilder withServerName(String serverName) {
        this.event.setServerName(serverName);
        return this;
    }

    public EventBuilder withExtra(String extraName, Object extraValue) {
        this.event.getExtra().put(extraName, extraValue);
        return this;
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface) {
        return this.withSentryInterface(sentryInterface, true);
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface, boolean replace) {
        if (replace || !this.event.getSentryInterfaces().containsKey(sentryInterface.getInterfaceName())) {
            this.event.getSentryInterfaces().put(sentryInterface.getInterfaceName(), sentryInterface);
        }
        return this;
    }

    public synchronized Event build() {
        if (this.alreadyBuilt) {
            throw new IllegalStateException("A message can't be built twice");
        }
        EventBuilder.autoSetMissingValues(this.event);
        EventBuilder.makeImmutable(this.event);
        this.alreadyBuilt = true;
        return this.event;
    }

    public String toString() {
        return "EventBuilder{event=" + this.event + ", alreadyBuilt=" + this.alreadyBuilt + '}';
    }

    private static final class HostnameCache {
        public static final long GET_HOSTNAME_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
        private static final Logger logger = LoggerFactory.getLogger(HostnameCache.class);
        private final long cacheDuration;
        private String hostname = "unavailable";
        private long expirationTimestamp;

        private HostnameCache(long cacheDuration) {
            this.cacheDuration = cacheDuration;
        }

        public String getHostname() {
            if (this.expirationTimestamp < System.currentTimeMillis()) {
                this.updateCache();
            }
            return this.hostname;
        }

        public void updateCache() {
            FutureTask<String> futureTask = new FutureTask<String>(new HostRetriever());
            try {
                new Thread(futureTask).start();
                logger.debug("Updating the hostname cache");
                this.hostname = futureTask.get(GET_HOSTNAME_TIMEOUT, TimeUnit.MILLISECONDS);
                this.expirationTimestamp = System.currentTimeMillis() + this.cacheDuration;
            }
            catch (Exception e) {
                futureTask.cancel(true);
                this.expirationTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L);
                logger.warn("Localhost hostname lookup failed, keeping the value '{}'", this.hostname, e);
            }
        }

        private static final class HostRetriever
        implements Callable<String> {
            private HostRetriever() {
            }

            @Override
            public String call() throws Exception {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
    }
}

