/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.event.interfaces;

import java.util.Arrays;
import shaded.com.getsentry.raven.event.interfaces.SentryInterface;

public class StackTraceInterface
implements SentryInterface {
    private final StackTraceElement[] stackTrace;
    private final int framesCommonWithEnclosing;

    public StackTraceInterface(StackTraceElement[] stackTrace, StackTraceElement[] enclosingStackTrace) {
        this.stackTrace = Arrays.copyOf(stackTrace, stackTrace.length);
        int m = stackTrace.length - 1;
        for (int n = enclosingStackTrace.length - 1; m >= 0 && n >= 0 && stackTrace[m].equals(enclosingStackTrace[n]); --m, --n) {
        }
        this.framesCommonWithEnclosing = stackTrace.length - 1 - m;
    }

    @Override
    public String getInterfaceName() {
        return "sentry.interfaces.Stacktrace";
    }

    public StackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTrace, this.stackTrace.length);
    }

    public int getFramesCommonWithEnclosing() {
        return this.framesCommonWithEnclosing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackTraceInterface that = (StackTraceInterface)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }

    public String toString() {
        return "StackTraceInterface{stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }
}

