/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.marshaller.json;

import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;
import shaded.com.getsentry.raven.event.interfaces.SentryException;
import shaded.com.getsentry.raven.event.interfaces.StackTraceInterface;
import shaded.com.getsentry.raven.marshaller.json.InterfaceBinding;

public class ExceptionInterfaceBinding
implements InterfaceBinding<ExceptionInterface> {
    private final InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding;

    public ExceptionInterfaceBinding(InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding) {
        this.stackTraceInterfaceBinding = stackTraceInterfaceBinding;
    }

    @Override
    public void writeInterface(JsonGenerator generator, ExceptionInterface exceptionInterface) throws IOException {
        Deque<SentryException> exceptions = exceptionInterface.getExceptions();
        generator.writeStartArray();
        Iterator<SentryException> iterator = exceptions.descendingIterator();
        while (iterator.hasNext()) {
            this.writeException(generator, iterator.next());
        }
        generator.writeEndArray();
    }

    private void writeException(JsonGenerator generator, SentryException sentryException) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", sentryException.getExceptionClassName());
        generator.writeStringField("value", sentryException.getExceptionMessage());
        generator.writeStringField("module", sentryException.getExceptionPackageName());
        generator.writeFieldName("stacktrace");
        this.stackTraceInterfaceBinding.writeInterface(generator, sentryException.getStackTraceInterface());
        generator.writeEndObject();
    }
}

