/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.marshaller.json;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.getsentry.raven.event.interfaces.HttpInterface;
import shaded.com.getsentry.raven.marshaller.json.InterfaceBinding;

public class HttpInterfaceBinding
implements InterfaceBinding<HttpInterface> {
    @Override
    public void writeInterface(JsonGenerator generator, HttpInterface httpInterface) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("url", httpInterface.getRequestUrl());
        generator.writeStringField("method", httpInterface.getMethod());
        generator.writeFieldName("data");
        this.writeData(generator, httpInterface.getParameters());
        generator.writeStringField("query_string", httpInterface.getQueryString());
        generator.writeFieldName("cookies");
        this.writeCookies(generator, httpInterface.getCookies());
        generator.writeFieldName("headers");
        this.writeHeaders(generator, httpInterface.getHeaders());
        generator.writeFieldName("env");
        this.writeEnvironment(generator, httpInterface);
        generator.writeEndObject();
    }

    private void writeEnvironment(JsonGenerator generator, HttpInterface httpInterface) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("REMOTE_ADDR", httpInterface.getRemoteAddr());
        generator.writeStringField("SERVER_NAME", httpInterface.getServerName());
        generator.writeNumberField("SERVER_PORT", httpInterface.getServerPort());
        generator.writeStringField("LOCAL_ADDR", httpInterface.getLocalAddr());
        generator.writeStringField("LOCAL_NAME", httpInterface.getLocalName());
        generator.writeNumberField("LOCAL_PORT", httpInterface.getLocalPort());
        generator.writeStringField("SERVER_PROTOCOL", httpInterface.getProtocol());
        generator.writeBooleanField("REQUEST_SECURE", httpInterface.isSecure());
        generator.writeBooleanField("REQUEST_ASYNC", httpInterface.isAsyncStarted());
        generator.writeStringField("AUTH_TYPE", httpInterface.getAuthType());
        generator.writeStringField("REMOTE_USER", httpInterface.getRemoteUser());
        generator.writeEndObject();
    }

    private void writeHeaders(JsonGenerator generator, Map<String, Collection<String>> headers) throws IOException {
        generator.writeStartArray();
        for (Map.Entry<String, Collection<String>> headerEntry : headers.entrySet()) {
            for (String value : headerEntry.getValue()) {
                generator.writeStartArray();
                generator.writeString(headerEntry.getKey());
                generator.writeString(value);
                generator.writeEndArray();
            }
        }
        generator.writeEndArray();
    }

    private void writeCookies(JsonGenerator generator, Map<String, String> cookies) throws IOException {
        if (cookies.isEmpty()) {
            generator.writeNull();
            return;
        }
        generator.writeStartObject();
        for (Map.Entry<String, String> cookie : cookies.entrySet()) {
            generator.writeStringField(cookie.getKey(), cookie.getValue());
        }
        generator.writeEndObject();
    }

    private void writeData(JsonGenerator generator, Map<String, Collection<String>> parameterMap) throws IOException {
        if (parameterMap == null) {
            generator.writeNull();
            return;
        }
        generator.writeStartObject();
        for (Map.Entry<String, Collection<String>> parameter : parameterMap.entrySet()) {
            generator.writeArrayFieldStart(parameter.getKey());
            for (String parameterValue : parameter.getValue()) {
                generator.writeString(parameterValue);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }
}

