/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.marshaller.json;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.DeflaterOutputStream;
import shaded.com.fasterxml.jackson.core.JsonFactory;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.interfaces.SentryInterface;
import shaded.com.getsentry.raven.marshaller.Marshaller;
import shaded.com.getsentry.raven.marshaller.json.InterfaceBinding;
import shaded.com.getsentry.raven.util.Base64OutputStream;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class JsonMarshaller
implements Marshaller {
    private static final ThreadLocal<DateFormat> ISO_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JsonMarshaller.class);
    private final JsonFactory jsonFactory = new JsonFactory();
    private final Map<Class<? extends SentryInterface>, InterfaceBinding<?>> interfaceBindings = new HashMap();
    private boolean compression = true;
    private final int maxMessageLength;

    public JsonMarshaller() {
        this.maxMessageLength = 1000;
    }

    public JsonMarshaller(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshall(Event event, OutputStream destination) {
        destination = new Marshaller.UncloseableOutputStream(destination);
        if (this.compression) {
            destination = new DeflaterOutputStream(new Base64OutputStream(destination, 2));
        }
        try {
            JsonGenerator generator = this.jsonFactory.createGenerator(destination);
            Throwable throwable = null;
            try {
                this.writeContent(generator, event);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (generator != null) {
                    if (throwable != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        generator.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("An exception occurred while serialising the event.", e);
        }
        finally {
            try {
                destination.close();
            }
            catch (IOException e) {
                logger.error("An exception occurred while serialising the event.", e);
            }
        }
    }

    private void writeContent(JsonGenerator generator, Event event) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("event_id", this.formatId(event.getId()));
        generator.writeStringField("message", this.trimMessage(event.getMessage()));
        generator.writeStringField("timestamp", ISO_FORMAT.get().format(event.getTimestamp()));
        generator.writeStringField("level", this.formatLevel(event.getLevel()));
        generator.writeStringField("logger", event.getLogger());
        generator.writeStringField("platform", event.getPlatform());
        generator.writeStringField("culprit", event.getCulprit());
        this.writeTags(generator, event.getTags());
        this.writeBreadcumbs(generator, event.getBreadcrumbs());
        generator.writeStringField("server_name", event.getServerName());
        generator.writeStringField("release", event.getRelease());
        generator.writeStringField("environment", event.getEnvironment());
        this.writeExtras(generator, event.getExtra());
        this.writeCollection(generator, "fingerprint", event.getFingerprint());
        generator.writeStringField("checksum", event.getChecksum());
        this.writeInterfaces(generator, event.getSentryInterfaces());
        generator.writeEndObject();
    }

    private void writeInterfaces(JsonGenerator generator, Map<String, SentryInterface> sentryInterfaces) throws IOException {
        for (Map.Entry<String, SentryInterface> interfaceEntry : sentryInterfaces.entrySet()) {
            SentryInterface sentryInterface = interfaceEntry.getValue();
            if (this.interfaceBindings.containsKey(sentryInterface.getClass())) {
                generator.writeFieldName(interfaceEntry.getKey());
                this.getInterfaceBinding(sentryInterface).writeInterface(generator, interfaceEntry.getValue());
                continue;
            }
            logger.error("Couldn't parse the content of '{}' provided in {}.", interfaceEntry.getKey(), sentryInterface);
        }
    }

    private <T extends SentryInterface> InterfaceBinding<? super T> getInterfaceBinding(T sentryInterface) {
        return this.interfaceBindings.get(sentryInterface.getClass());
    }

    private void writeExtras(JsonGenerator generator, Map<String, Object> extras) throws IOException {
        generator.writeObjectFieldStart("extra");
        for (Map.Entry<String, Object> extra : extras.entrySet()) {
            generator.writeFieldName(extra.getKey());
            this.safelyWriteObject(generator, extra.getValue());
        }
        generator.writeEndObject();
    }

    private void writeCollection(JsonGenerator generator, String name, Collection<String> value) throws IOException {
        if (value != null && !value.isEmpty()) {
            generator.writeArrayFieldStart(name);
            for (String element : value) {
                generator.writeString(element);
            }
            generator.writeEndArray();
        }
    }

    private void safelyWriteObject(JsonGenerator generator, Object value) throws IOException {
        if (value != null && value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Iterable) {
            generator.writeStartArray();
            for (Object subValue : (Iterable)value) {
                this.safelyWriteObject(generator, subValue);
            }
            generator.writeEndArray();
        } else if (value instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)((Object)value)).entrySet()) {
                if (entry.getKey() == null) {
                    generator.writeFieldName("null");
                } else {
                    generator.writeFieldName(entry.getKey().toString());
                }
                this.safelyWriteObject(generator, entry.getValue());
            }
            generator.writeEndObject();
        } else if (value == null) {
            generator.writeNull();
        } else {
            try {
                generator.writeObject(value);
            }
            catch (IllegalStateException e) {
                logger.debug("Couldn't marshal '{}' of type '{}', had to be converted into a String", value, value.getClass());
                generator.writeString(value.toString());
            }
        }
    }

    private void writeTags(JsonGenerator generator, Map<String, String> tags) throws IOException {
        generator.writeObjectFieldStart("tags");
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            generator.writeStringField(tag.getKey(), tag.getValue());
        }
        generator.writeEndObject();
    }

    private void writeBreadcumbs(JsonGenerator generator, List<Breadcrumb> breadcrumbs) throws IOException {
        if (breadcrumbs.size() < 1) {
            return;
        }
        generator.writeObjectFieldStart("breadcrumbs");
        generator.writeArrayFieldStart("values");
        for (Breadcrumb breadcrumb : breadcrumbs) {
            generator.writeStartObject();
            generator.writeNumberField("timestamp", breadcrumb.getTimestamp().getTime() / 1000L);
            if (breadcrumb.getType() != null) {
                generator.writeStringField("type", breadcrumb.getType());
            }
            if (breadcrumb.getLevel() != null) {
                generator.writeStringField("level", breadcrumb.getLevel());
            }
            if (breadcrumb.getMessage() != null) {
                generator.writeStringField("message", breadcrumb.getMessage());
            }
            if (breadcrumb.getCategory() != null) {
                generator.writeStringField("category", breadcrumb.getCategory());
            }
            if (breadcrumb.getData() != null && breadcrumb.getData().size() > 0) {
                generator.writeObjectFieldStart("data");
                for (Map.Entry<String, String> entry : breadcrumb.getData().entrySet()) {
                    generator.writeStringField(entry.getKey(), entry.getValue());
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private String trimMessage(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() > this.maxMessageLength) {
            return message.substring(0, this.maxMessageLength);
        }
        return message;
    }

    private String formatId(UUID id) {
        return id.toString().replaceAll("-", "");
    }

    private String formatLevel(Event.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case DEBUG: {
                return "debug";
            }
            case FATAL: {
                return "fatal";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
        }
        logger.error("The level '{}' isn't supported, this should NEVER happen, contact Raven developers", level.name());
        return null;
    }

    public <T extends SentryInterface, F extends T> void addInterfaceBinding(Class<F> sentryInterfaceClass, InterfaceBinding<T> binding) {
        this.interfaceBindings.put(sentryInterfaceClass, binding);
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }
}

