/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.marshaller.json;

import java.io.IOException;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.getsentry.raven.event.interfaces.MessageInterface;
import shaded.com.getsentry.raven.marshaller.json.InterfaceBinding;

public class MessageInterfaceBinding
implements InterfaceBinding<MessageInterface> {
    private final int maxMessageLength;

    public MessageInterfaceBinding() {
        this.maxMessageLength = 1000;
    }

    public MessageInterfaceBinding(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    private String trimMessage(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() > this.maxMessageLength) {
            return message.substring(0, this.maxMessageLength);
        }
        return message;
    }

    @Override
    public void writeInterface(JsonGenerator generator, MessageInterface messageInterface) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("message", this.trimMessage(messageInterface.getMessage()));
        generator.writeArrayFieldStart("params");
        for (String parameter : messageInterface.getParameters()) {
            generator.writeString(parameter);
        }
        generator.writeEndArray();
        if (messageInterface.getFormatted() != null) {
            generator.writeStringField("formatted", this.trimMessage(messageInterface.getFormatted()));
        }
        generator.writeEndObject();
    }
}

