/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.marshaller.json;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.getsentry.raven.event.interfaces.StackTraceInterface;
import shaded.com.getsentry.raven.marshaller.json.InterfaceBinding;

public class StackTraceInterfaceBinding
implements InterfaceBinding<StackTraceInterface> {
    private Collection<String> notInAppFrames = Collections.emptyList();
    private boolean removeCommonFramesWithEnclosing = true;

    private void writeFrame(JsonGenerator generator, StackTraceElement stackTraceElement, boolean commonWithEnclosing) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("filename", stackTraceElement.getFileName());
        generator.writeStringField("module", stackTraceElement.getClassName());
        generator.writeBooleanField("in_app", (!this.removeCommonFramesWithEnclosing || !commonWithEnclosing) && this.isFrameInApp(stackTraceElement));
        generator.writeStringField("function", stackTraceElement.getMethodName());
        generator.writeNumberField("lineno", stackTraceElement.getLineNumber());
        generator.writeEndObject();
    }

    private boolean isFrameInApp(StackTraceElement stackTraceElement) {
        for (String notInAppFrame : this.notInAppFrames) {
            if (!stackTraceElement.getClassName().startsWith(notInAppFrame)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeInterface(JsonGenerator generator, StackTraceInterface stackTraceInterface) throws IOException {
        StackTraceElement[] stackTrace = stackTraceInterface.getStackTrace();
        generator.writeStartObject();
        generator.writeArrayFieldStart("frames");
        int commonWithEnclosing = stackTraceInterface.getFramesCommonWithEnclosing();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            this.writeFrame(generator, stackTrace[i], commonWithEnclosing-- > 0);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    public void setRemoveCommonFramesWithEnclosing(boolean removeCommonFramesWithEnclosing) {
        this.removeCommonFramesWithEnclosing = removeCommonFramesWithEnclosing;
    }

    public void setNotInAppFrames(Collection<String> notInAppFrames) {
        this.notInAppFrames = notInAppFrames;
    }
}

