/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.github.zafarkhaja.semver;

import java.util.Comparator;
import shaded.com.github.zafarkhaja.semver.MetadataVersion;
import shaded.com.github.zafarkhaja.semver.NormalVersion;
import shaded.com.github.zafarkhaja.semver.VersionParser;

public class Version
implements Comparable<Version> {
    private final NormalVersion normal;
    private final MetadataVersion preRelease;
    private final MetadataVersion build;
    public static final Comparator<Version> BUILD_AWARE_ORDER = new BuildAwareOrder();

    Version(NormalVersion normal, MetadataVersion preRelease, MetadataVersion build) {
        this.normal = normal;
        this.preRelease = preRelease;
        this.build = build;
    }

    public static Version valueOf(String version) {
        return VersionParser.parseValidSemVer(version);
    }

    public String getNormalVersion() {
        return this.normal.toString();
    }

    public String getPreReleaseVersion() {
        return this.preRelease.toString();
    }

    public String getBuildMetadata() {
        return this.build.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.normal.hashCode();
        hash = 97 * hash + this.preRelease.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getNormalVersion());
        if (!this.getPreReleaseVersion().isEmpty()) {
            sb.append("-").append(this.getPreReleaseVersion());
        }
        if (!this.getBuildMetadata().isEmpty()) {
            sb.append("+").append(this.getBuildMetadata());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Version other) {
        int result = this.normal.compareTo(other.normal);
        if (result == 0) {
            result = this.preRelease.compareTo(other.preRelease);
        }
        return result;
    }

    private static class BuildAwareOrder
    implements Comparator<Version> {
        private BuildAwareOrder() {
        }

        @Override
        public int compare(Version v1, Version v2) {
            int result = v1.compareTo(v2);
            if (result == 0) {
                result = v1.build.compareTo(v2.build);
                if (v1.build == MetadataVersion.NULL || v2.build == MetadataVersion.NULL) {
                    result = -1 * result;
                }
            }
            return result;
        }
    }
}

