/*
 * Decompiled with CFR 0.152.
 */
package shaded.joptsimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.joptsimple.ArgumentList;
import shaded.joptsimple.OptionArgumentConversionException;
import shaded.joptsimple.OptionDescriptor;
import shaded.joptsimple.OptionParser;
import shaded.joptsimple.OptionSet;
import shaded.joptsimple.OptionSpec;
import shaded.joptsimple.ValueConversionException;
import shaded.joptsimple.ValueConverter;
import shaded.joptsimple.internal.Reflection;
import shaded.joptsimple.internal.ReflectionException;

abstract class AbstractOptionSpec<V>
implements OptionDescriptor,
OptionSpec<V> {
    private final List<String> options = new ArrayList<String>();
    private final String description;
    private boolean forHelp;

    protected AbstractOptionSpec(List<String> options, String description) {
        this.arrangeOptions(options);
        this.description = description;
    }

    @Override
    public final List<String> options() {
        return Collections.unmodifiableList(this.options);
    }

    public final V value(OptionSet detectedOptions) {
        return detectedOptions.valueOf(this);
    }

    public String description() {
        return this.description;
    }

    public final boolean isForHelp() {
        return this.forHelp;
    }

    protected abstract V convert(String var1);

    protected V convertWith(ValueConverter<V> converter, String argument) {
        try {
            return Reflection.convertWith(converter, argument);
        }
        catch (ReflectionException ex) {
            throw new OptionArgumentConversionException(this, argument, ex);
        }
        catch (ValueConversionException ex) {
            throw new OptionArgumentConversionException(this, argument, ex);
        }
    }

    abstract void handleOption(OptionParser var1, ArgumentList var2, OptionSet var3, String var4);

    private void arrangeOptions(List<String> unarranged) {
        if (unarranged.size() == 1) {
            this.options.addAll(unarranged);
            return;
        }
        ArrayList<String> shortOptions = new ArrayList<String>();
        ArrayList<String> longOptions = new ArrayList<String>();
        for (String each : unarranged) {
            if (each.length() == 1) {
                shortOptions.add(each);
                continue;
            }
            longOptions.add(each);
        }
        Collections.sort(shortOptions);
        Collections.sort(longOptions);
        this.options.addAll(shortOptions);
        this.options.addAll(longOptions);
    }

    public boolean equals(Object that) {
        if (!(that instanceof AbstractOptionSpec)) {
            return false;
        }
        AbstractOptionSpec other = (AbstractOptionSpec)that;
        return this.options.equals(other.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return this.options.toString();
    }
}

