/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.slf4j.event;

import java.util.Queue;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.Marker;
import shaded.org.slf4j.event.Level;
import shaded.org.slf4j.event.SubstituteLoggingEvent;
import shaded.org.slf4j.helpers.SubstituteLogger;

public class EventRecodingLogger
implements Logger {
    String name;
    SubstituteLogger logger;
    Queue<SubstituteLoggingEvent> eventQueue;

    public EventRecodingLogger(SubstituteLogger logger, Queue<SubstituteLoggingEvent> eventQueue) {
        this.logger = logger;
        this.name = logger.getName();
        this.eventQueue = eventQueue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void recordEvent(Level level, String msg, Object[] args, Throwable throwable) {
        this.recordEvent(level, null, msg, args, throwable);
    }

    private void recordEvent(Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        SubstituteLoggingEvent loggingEvent = new SubstituteLoggingEvent();
        loggingEvent.setTimeStamp(System.currentTimeMillis());
        loggingEvent.setLevel(level);
        loggingEvent.setLogger(this.logger);
        loggingEvent.setLoggerName(this.name);
        loggingEvent.setMessage(msg);
        loggingEvent.setArgumentArray(args);
        loggingEvent.setThrowable(throwable);
        loggingEvent.setThreadName(Thread.currentThread().getName());
        this.eventQueue.add(loggingEvent);
    }

    @Override
    public void trace(String msg) {
        this.recordEvent(Level.TRACE, msg, null, null);
    }

    @Override
    public void debug(String msg) {
        this.recordEvent(Level.TRACE, msg, null, null);
    }

    @Override
    public void debug(String format, Object arg) {
        this.recordEvent(Level.DEBUG, format, new Object[]{arg}, null);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.recordEvent(Level.DEBUG, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.recordEvent(Level.DEBUG, msg, null, t);
    }

    @Override
    public void info(String msg) {
        this.recordEvent(Level.INFO, msg, null, null);
    }

    @Override
    public void info(String format, Object arg) {
        this.recordEvent(Level.INFO, format, new Object[]{arg}, null);
    }

    @Override
    public void warn(String msg) {
        this.recordEvent(Level.WARN, msg, null, null);
    }

    @Override
    public void warn(String format, Object arg) {
        this.recordEvent(Level.WARN, format, new Object[]{arg}, null);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.recordEvent(Level.WARN, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.recordEvent(Level.WARN, msg, null, t);
    }

    @Override
    public void error(String msg) {
        this.recordEvent(Level.ERROR, msg, null, null);
    }

    @Override
    public void error(String format, Object arg) {
        this.recordEvent(Level.ERROR, format, new Object[]{arg}, null);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.recordEvent(Level.ERROR, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.recordEvent(Level.ERROR, msg, null, t);
    }
}

