/*
 * Decompiled with CFR 0.152.
 */
package shaded.ru.turikhay.util.windows.wmi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.commons.lang3.StringUtils;
import shaded.ru.turikhay.util.windows.wmi.Codepage;

public final class WMI {
    private final String oWMIQuery;
    private final Charset charset;

    public WMI(String oWMIQuery, Charset encoding) {
        this.oWMIQuery = oWMIQuery;
        this.charset = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVbFile(File file, String wmiQueryStr, String wmiCommaSeparatedFieldName) throws IOException {
        Writer vbs = null;
        try {
            vbs = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
            vbs.append("Dim oWMI : Set oWMI = GetObject(\"winmgmts:").append(this.oWMIQuery).append("\")").append("\r\n");
            vbs.append("Dim classComponent : Set classComponent = oWMI.ExecQuery(\"").append(wmiQueryStr).append("\")").append("\r\n");
            vbs.append("Dim obj, strData").append("\r\n");
            vbs.append("For Each obj in classComponent").append("\r\n");
            for (String fieldName : StringUtils.split(wmiCommaSeparatedFieldName, ',')) {
                vbs.append("  strData = strData & obj.").append(fieldName).append(" & VBCrLf").append("\r\n");
            }
            vbs.append("Next").append("\r\n");
            vbs.append("wscript.echo strData").append("\r\n");
        }
        finally {
            if (vbs != null) {
                vbs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWMIValues(String wmiQueryStr, String fieldName) throws Exception {
        File tmpFile = File.createTempFile("wmi", ".vbs");
        tmpFile.deleteOnExit();
        try {
            this.writeVbFile(tmpFile, wmiQueryStr, fieldName);
            List<String> list = WMI.execute(new String[]{"cmd.exe", "/C", "cscript.exe", tmpFile.getAbsolutePath()}, this.charset);
            return list;
        }
        finally {
            tmpFile.delete();
        }
    }

    static List<String> execute(String[] cmdArray, Charset charset) throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec(cmdArray);
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));
        ArrayList<String> output = new ArrayList<String>();
        while ((line = input.readLine()) != null) {
            if (line.contains("Copyright") || line.contains("Microsoft") || line.isEmpty()) continue;
            output.add(line);
        }
        process.destroy();
        return output;
    }

    public static List<String> getAVSoftwareList() throws Exception {
        Charset charset = Codepage.get() == null ? Charset.defaultCharset() : Codepage.get().getCharset();
        WMI wmi = new WMI("{impersonationLevel=impersonate}!\\\\.\\root\\SecurityCenter2", charset);
        return wmi.getWMIValues("Select * from AntiVirusProduct", "displayName");
    }
}

